/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.jackson.serialize.JsonNodeDeserializer;
import io.micronaut.json.convert.JsonNodeConvertibleValues;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;

@Internal
final class ConvertibleValuesDeserializer<V>
extends JsonDeserializer<ConvertibleValues<V>>
implements ContextualDeserializer {
    private static final JsonNodeDeserializer JSON_NODE_DESERIALIZER = new JsonNodeDeserializer();
    private final ConversionService conversionService;
    @Nullable
    private final JavaType valueType;
    @Nullable
    private final JsonDeserializer<V> valueDeserializer;

    ConvertibleValuesDeserializer(@NonNull ConversionService conversionService, @Nullable JavaType valueType) {
        this(conversionService, valueType, null);
    }

    private ConvertibleValuesDeserializer(@NonNull ConversionService conversionService, @Nullable JavaType valueType, @Nullable JsonDeserializer<V> valueDeserializer) {
        this.conversionService = conversionService;
        this.valueType = valueType;
        this.valueDeserializer = valueDeserializer;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (this.valueType == null) {
            return this;
        }
        JsonDeserializer valueDeserializer = ctxt.findContextualValueDeserializer(this.valueType, property);
        return new ConvertibleValuesDeserializer<V>(this.conversionService, this.valueType, valueDeserializer);
    }

    public ConvertibleValues<V> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        if (this.valueDeserializer == null) {
            if (!p.hasCurrentToken()) {
                p.nextToken();
            }
            if (p.getCurrentToken() != JsonToken.START_OBJECT) {
                return (ConvertibleValues)ctxt.handleUnexpectedToken(this.handledType(), p);
            }
            JsonNode node = JSON_NODE_DESERIALIZER.deserialize(p, ctxt);
            return new JsonNodeConvertibleValues(node, this.conversionService);
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        if (t != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT) {
            return (ConvertibleValues)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        MutableConvertibleValuesMap map = new MutableConvertibleValuesMap();
        map.setConversionService(this.conversionService);
        while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = p.getCurrentName();
            p.nextToken();
            map.put((CharSequence)fieldName, this.valueDeserializer.deserialize(p, ctxt));
            p.nextToken();
        }
        return map;
    }
}

