/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpStatus;
import io.micronaut.web.router.MethodBasedRouteInfo;
import io.micronaut.web.router.RequestMatcher;
import io.micronaut.web.router.RouteMatch;
import java.util.Optional;

public interface StatusRouteInfo<T, R>
extends MethodBasedRouteInfo<T, R>,
RequestMatcher {
    @Nullable
    public Class<?> originatingType();

    public HttpStatus status();

    default public int statusCode() {
        return this.status().getCode();
    }

    public Optional<RouteMatch<R>> match(HttpStatus var1);

    default public Optional<RouteMatch<R>> match(int statusCode) {
        HttpStatus status;
        try {
            status = HttpStatus.valueOf((int)statusCode);
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
        return this.match(status);
    }

    public Optional<RouteMatch<R>> match(Class<?> var1, HttpStatus var2);

    default public Optional<RouteMatch<R>> match(Class<?> originatingClass, int statusCode) {
        HttpStatus status;
        try {
            status = HttpStatus.valueOf((int)statusCode);
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
        return this.match(originatingClass, status);
    }
}

