/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.BeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.http.filter.BaseFilterProcessor;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RouteBuilder;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.function.Supplier;

@Singleton
public class ServerFilterRouteBuilder
extends DefaultRouteBuilder
implements ExecutableMethodProcessor<ServerFilter> {
    private final BaseFilterProcessor<ServerFilter> delegate;

    public ServerFilterRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService conversionService, BeanContext beanContext, final @Nullable ServerContextPathProvider contextPathProvider) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.delegate = new BaseFilterProcessor<ServerFilter>(beanContext, ServerFilter.class){

            @NonNull
            protected List<String> prependContextPath(@NonNull List<String> patterns) {
                String contextPath;
                String string = contextPath = contextPathProvider != null ? contextPathProvider.getContextPath() : null;
                if (contextPath != null) {
                    patterns = patterns.stream().map(pattern -> {
                        if (!pattern.startsWith(contextPath)) {
                            Object newValue = StringUtils.prependUri((String)contextPath, (String)pattern);
                            if (((String)newValue).charAt(0) != '/') {
                                newValue = "/" + (String)newValue;
                            }
                            return newValue;
                        }
                        return pattern;
                    }).toList();
                }
                return patterns;
            }

            protected void addFilter(Supplier<GenericHttpFilter> factory, AnnotationMetadata methodAnnotations, BaseFilterProcessor.FilterMetadata metadata) {
                this.applyMetadata(ServerFilterRouteBuilder.this.addFilter(factory, methodAnnotations, metadata.isPreMatching()), metadata);
            }

            private void applyMetadata(FilterRoute route, BaseFilterProcessor.FilterMetadata metadata) {
                route.patternStyle(metadata.patternStyle());
                if (metadata.patterns() == null || metadata.patterns().isEmpty()) {
                    throw new IllegalArgumentException("A filter pattern is required");
                }
                for (String pattern : metadata.patterns()) {
                    route.pattern(pattern);
                }
                if (metadata.methods() != null) {
                    route.methods(metadata.methods().toArray(new HttpMethod[0]));
                }
            }
        };
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        this.delegate.process(beanDefinition, method);
    }
}

