/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.instrument;

import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ThreadLocalAccessor;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.reactor.config.ReactorConfiguration;
import io.micronaut.reactor.instrument.ReactorInstrumentation;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayDeque;
import java.util.Optional;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

@Requires(classes={Schedulers.class, ContextRegistry.class, PropagatedContext.class})
@Context
@Internal
@Replaces(value=ReactorInstrumentation.class)
final class ReactorAutomaticContextPropagation {
    private static final PropagatedContextThreadLocalAccessor ACCESSOR = new PropagatedContextThreadLocalAccessor();
    private final boolean enableAutomaticContextPropagation;
    private final boolean enableScheduleHookContextPropagation;

    ReactorAutomaticContextPropagation(ReactorConfiguration configuration) {
        this.enableAutomaticContextPropagation = Optional.ofNullable(configuration.enableAutomaticContextPropagation()).orElse(true);
        this.enableScheduleHookContextPropagation = Optional.ofNullable(configuration.enableScheduleHookContextPropagation()).orElse(false);
    }

    @PostConstruct
    void init() {
        if (this.enableScheduleHookContextPropagation) {
            Schedulers.onScheduleHook((String)"MICRONAUT_CONTEXT_PROPAGATION", PropagatedContext::wrapCurrent);
        }
        if (this.enableAutomaticContextPropagation) {
            Hooks.enableAutomaticContextPropagation();
            ContextRegistry.getInstance().registerThreadLocalAccessor((ThreadLocalAccessor)ACCESSOR);
        }
    }

    @PreDestroy
    void removeInstrumentation() {
        if (this.enableScheduleHookContextPropagation) {
            Schedulers.resetOnScheduleHook((String)"MICRONAUT_CONTEXT_PROPAGATION");
        }
        if (this.enableAutomaticContextPropagation) {
            ContextRegistry.getInstance().removeThreadLocalAccessor(ACCESSOR.key());
        }
    }

    private static class PropagatedContextThreadLocalAccessor
    implements ThreadLocalAccessor<PropagatedContext> {
        private final ThreadLocal<ArrayDeque<PropagatedContext.Scope>> localScopes = new ThreadLocal();

        private PropagatedContextThreadLocalAccessor() {
        }

        public String key() {
            return "micronaut.propagated.context";
        }

        public PropagatedContext getValue() {
            return PropagatedContext.find().orElse(null);
        }

        public void setValue(PropagatedContext propagatedContext) {
            ArrayDeque<Object> scopes = this.localScopes.get();
            if (scopes == null) {
                scopes = new ArrayDeque(5);
                this.localScopes.set(scopes);
            }
            scopes.push(propagatedContext.propagate());
        }

        public void setValue() {
            this.setValue(PropagatedContext.empty());
        }

        public void restore(PropagatedContext previousValue) {
            ArrayDeque<PropagatedContext.Scope> scopes = this.localScopes.get();
            if (scopes != null && !scopes.isEmpty()) {
                scopes.pop().close();
                if (scopes.isEmpty()) {
                    this.localScopes.remove();
                }
            }
        }

        public void restore() {
            ArrayDeque<PropagatedContext.Scope> scopes = this.localScopes.get();
            if (scopes != null && !scopes.isEmpty()) {
                scopes.pop().close();
                if (scopes.isEmpty()) {
                    this.localScopes.remove();
                }
            }
        }
    }
}

