/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson.custom;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.BsonWriterEncoder;
import io.micronaut.serde.bson.custom.AbstractBsonSerde;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

@Internal
public class CodecBsonDecoder<T>
extends AbstractBsonSerde<T> {
    private static final DecoderContext DEFAULT_DECODER_CONTEXT = DecoderContext.builder().build();
    private static final EncoderContext DEFAULT_ENCODER_CONTEXT = EncoderContext.builder().build();
    private final Codec<T> codec;

    public CodecBsonDecoder(Codec<T> codec) {
        this.codec = codec;
    }

    @Override
    protected T doDeserialize(BsonReaderDecoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type) {
        try {
            return decoder.decodeCustom(this.codec, DEFAULT_DECODER_CONTEXT);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void doSerialize(BsonWriterEncoder encoder, Serializer.EncoderContext context, T value, Argument<? extends T> type) {
        this.codec.encode(encoder.getBsonWriter(), value, DEFAULT_ENCODER_CONTEXT);
    }
}

