/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.PackageRenameRemapper;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.processor.jackson.JacksonAnnotationMapper;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AwsRemapper
implements PackageRenameRemapper {
    public String getPackageName() {
        return "com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.annotation";
    }

    public String getTargetPackage() {
        return "com.fasterxml.jackson.annotation";
    }

    public List<AnnotationValue<?>> remap(AnnotationValue<?> annotation, VisitorContext visitorContext) {
        List remapped = super.remap(annotation, visitorContext);
        return remapped.stream().flatMap(av -> {
            List<AnnotationMapper<?>> annotationMappers = JacksonAnnotationMapper.JACKSON_ANNOTATION_MAPPERS.get(av.getAnnotationName());
            if (CollectionUtils.isNotEmpty(annotationMappers)) {
                return annotationMappers.stream().flatMap(annotationMapper -> annotationMapper.map(annotation, visitorContext).stream());
            }
            return Stream.of(av);
        }).collect(Collectors.toList());
    }
}

