/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson.databind;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.IdentityStrategy;
import io.micronaut.serde.config.naming.KebabCaseStrategy;
import io.micronaut.serde.config.naming.LowerCaseStrategy;
import io.micronaut.serde.config.naming.LowerDotCaseStrategy;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.config.naming.SnakeCaseStrategy;
import io.micronaut.serde.config.naming.UpperCamelCaseStrategy;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public class JsonNamingMapper
implements NamedAnnotationMapper {
    public String getName() {
        return "com.fasterxml.jackson.databind.annotation.JsonNaming";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ClassElement e;
        AnnotationClassValue annotationClassValue = annotation.annotationClassValue("value").orElse(null);
        if (annotationClassValue != null && (e = (ClassElement)visitorContext.getClassElement(annotationClassValue.getName()).orElse(null)) != null) {
            String className = e.getSimpleName();
            int i = className.indexOf(36);
            if (i > -1) {
                className = className.substring(i + 1);
            }
            switch (className) {
                case "LowerCamelCaseStrategy": {
                    return this.namingStrategy(IdentityStrategy.class);
                }
                case "UpperCamelCaseStrategy": {
                    return this.namingStrategy(UpperCamelCaseStrategy.class);
                }
                case "SnakeCaseStrategy": {
                    return this.namingStrategy(SnakeCaseStrategy.class);
                }
                case "LowerCaseStrategy": {
                    return this.namingStrategy(LowerCaseStrategy.class);
                }
                case "KebabCaseStrategy": {
                    return this.namingStrategy(KebabCaseStrategy.class);
                }
                case "LowerDotCaseStrategy": {
                    return this.namingStrategy(LowerDotCaseStrategy.class);
                }
            }
            return this.unsupported(className);
        }
        return Collections.emptyList();
    }

    private List<AnnotationValue<?>> unsupported(String className) {
        return Collections.singletonList(AnnotationValue.builder(SerdeConfig.SerError.class).value("Unsupported Databind naming strategy: " + className).build());
    }

    private List<AnnotationValue<?>> namingStrategy(Class<? extends PropertyNamingStrategy> strategy) {
        return Collections.singletonList(AnnotationValue.builder(SerdeConfig.class).member("naming", new AnnotationClassValue[]{new AnnotationClassValue(strategy)}).build());
    }
}

