/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.nio.charset.Charset;

@Internal
final class CharsetSerde
implements SerdeRegistrar<Charset> {
    CharsetSerde() {
    }

    @Override
    public Argument<Charset> getType() {
        return Argument.of(Charset.class);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Charset> type, Charset value) throws IOException {
        encoder.encodeString(value.name());
    }

    public Charset deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Charset> type) throws IOException {
        return Charset.forName(decoder.decodeString());
    }

    public Charset deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Charset> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }
}

