/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.EnumBeanIntrospection;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.EnumCreatorDeserializer;
import io.micronaut.serde.support.serdes.EnumPropertyDeserializer;
import io.micronaut.serde.support.serdes.EnumPropertySerializer;
import io.micronaut.serde.support.serdes.EnumValueDeserializer;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;

final class EnumSerde<E extends Enum<E>>
implements SerdeRegistrar<E> {
    private final SerdeIntrospections introspections;

    EnumSerde(SerdeIntrospections introspections) {
        this.introspections = introspections;
    }

    @NonNull
    public E deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super E> type) throws IOException {
        Class t = type.getType();
        String s = decoder.decodeString();
        try {
            return (E)Enum.valueOf(t, s);
        }
        catch (IllegalArgumentException e) {
            try {
                return (E)Enum.valueOf(t, s.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                throw e;
            }
        }
    }

    @NonNull
    public Deserializer<E> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) {
        try {
            BeanIntrospection deserializableIntrospection = this.introspections.getDeserializableIntrospection(type);
            if (deserializableIntrospection.getConstructor().isAnnotationPresent(Creator.class)) {
                return this.createEnumCreatorDeserializer(context, deserializableIntrospection);
            }
            if (deserializableIntrospection instanceof EnumBeanIntrospection) {
                EnumBeanIntrospection enumBeanIntrospection = (EnumBeanIntrospection)deserializableIntrospection;
                for (BeanMethod beanMethod : deserializableIntrospection.getBeanMethods()) {
                    if (!beanMethod.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                    Argument valueType = beanMethod.getReturnType().asArgument();
                    Deserializer valueDeserializer = context.findDeserializer(valueType);
                    HashMap<Object, Enum> cache = new HashMap<Object, Enum>();
                    for (EnumBeanIntrospection.EnumConstant enumConstant : enumBeanIntrospection.getConstants()) {
                        Enum enumValue = (Enum)enumConstant.getValue();
                        Object deserializedValue = beanMethod.invoke((Object)enumValue, new Object[0]);
                        cache.put(deserializedValue, enumValue);
                    }
                    return new EnumValueDeserializer((Argument<Object>)valueType, valueDeserializer, valueType.isNullable(), cache);
                }
                for (BeanProperty beanProperty : deserializableIntrospection.getBeanProperties()) {
                    if (!beanProperty.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                    Argument valueType = beanProperty.asArgument();
                    Deserializer valueDeserializer = context.findDeserializer(valueType);
                    HashMap<Object, Enum> cache = new HashMap<Object, Enum>();
                    for (EnumBeanIntrospection.EnumConstant enumConstant : enumBeanIntrospection.getConstants()) {
                        Enum enumValue = (Enum)enumConstant.getValue();
                        Object deserializedValue = beanProperty.get((Object)enumValue);
                        cache.put(deserializedValue, enumValue);
                    }
                    return new EnumValueDeserializer((Argument<Object>)valueType, valueDeserializer, valueType.isNullable(), cache);
                }
                HashMap<String, Enum> cache = new HashMap<String, Enum>();
                for (EnumBeanIntrospection.EnumConstant enumConstant : enumBeanIntrospection.getConstants()) {
                    Enum enumValue = (Enum)enumConstant.getValue();
                    String enumAsString = enumConstant.stringValue(SerdeConfig.class, "property").orElse(null);
                    if (enumAsString == null) {
                        enumAsString = enumValue.name();
                    }
                    cache.put(enumAsString, enumValue);
                    cache.put(enumAsString.toLowerCase(Locale.ENGLISH), enumValue);
                }
                return new EnumPropertyDeserializer(cache);
            }
            return this.createEnumCreatorDeserializer(context, deserializableIntrospection);
        }
        catch (IntrospectionException | SerdeException e) {
            return this;
        }
    }

    private EnumCreatorDeserializer<E> createEnumCreatorDeserializer(Deserializer.DecoderContext context, BeanIntrospection<? super E> deserializableIntrospection) throws SerdeException {
        Argument[] constructorArguments = deserializableIntrospection.getConstructorArguments();
        if (constructorArguments.length != 1) {
            throw new SerdeException("Creator method for Enums must accept exactly 1 argument");
        }
        Argument argumentType = constructorArguments[0];
        Deserializer argumentDeserializer = context.findDeserializer(argumentType);
        return new EnumCreatorDeserializer<E>((Argument<Object>)argumentType, (Deserializer<Object>)argumentDeserializer, deserializableIntrospection, argumentType.isNullable());
    }

    @NonNull
    public Serializer<E> createSpecific(@NonNull Serializer.EncoderContext context, @NonNull Argument<? extends E> type) throws SerdeException {
        try {
            EnumBeanIntrospection enumBeanIntrospection;
            BeanIntrospection si = this.introspections.getSerializableIntrospection(type);
            for (BeanMethod beanMethod : si.getBeanMethods()) {
                if (!beanMethod.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                Serializer valueSerializer = context.findSerializer(beanMethod.getReturnType().asArgument());
                return (encoder, subContext, subType, value) -> {
                    Object result = beanMethod.invoke(value, new Object[0]);
                    if (result == null) {
                        encoder.encodeNull();
                    } else {
                        valueSerializer.serialize(encoder, subContext, subType, result);
                    }
                };
            }
            for (BeanProperty beanProperty : si.getBeanProperties()) {
                if (!beanProperty.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                Serializer valueSerializer = context.findSerializer(beanProperty.asArgument());
                return (encoder, subContext, subType, value) -> {
                    Object result = beanProperty.get(value);
                    if (result == null) {
                        encoder.encodeNull();
                    } else {
                        valueSerializer.serialize(encoder, subContext, subType, result);
                    }
                };
            }
            if (si instanceof EnumBeanIntrospection && (enumBeanIntrospection = (EnumBeanIntrospection)si).getConstants().stream().anyMatch(enumConstant -> enumConstant.stringValue(SerdeConfig.class, "property").isPresent())) {
                EnumMap<Enum, String> cache = new EnumMap<Enum, String>(enumBeanIntrospection.getBeanType());
                for (EnumBeanIntrospection.EnumConstant enumConstant2 : enumBeanIntrospection.getConstants()) {
                    Enum enumValue = (Enum)enumConstant2.getValue();
                    String enumAsString = enumConstant2.stringValue(SerdeConfig.class, "property").orElse(null);
                    if (enumAsString == null) {
                        enumAsString = enumValue.name();
                    }
                    cache.put(enumValue, enumAsString);
                }
                return new EnumPropertySerializer(cache);
            }
            return this;
        }
        catch (IntrospectionException e) {
            return this;
        }
    }

    public void serialize(Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends E> type, E value) throws IOException {
        encoder.encodeString(((Enum)value).name());
    }

    @Override
    public Argument<E> getType() {
        return Argument.ofTypeVariable(Enum.class, (String)"E");
    }
}

