/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.JsonNodeSerde;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

final class JacksonJsonNodeSerde
implements SerdeRegistrar<com.fasterxml.jackson.databind.JsonNode> {
    @NonNull
    private static final Argument<com.fasterxml.jackson.databind.JsonNode> JSON_NODE_ARGUMENT = Argument.of(com.fasterxml.jackson.databind.JsonNode.class);

    JacksonJsonNodeSerde() {
    }

    @Override
    @NonNull
    public Argument<com.fasterxml.jackson.databind.JsonNode> getType() {
        return JSON_NODE_ARGUMENT;
    }

    public com.fasterxml.jackson.databind.JsonNode deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super com.fasterxml.jackson.databind.JsonNode> type) throws IOException {
        return this.deserialize(decoder, context, type);
    }

    @Nullable
    public com.fasterxml.jackson.databind.JsonNode deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super com.fasterxml.jackson.databind.JsonNode> type) throws IOException {
        return JacksonJsonNodeSerde.toJacksonNode(JsonNodeFactory.instance, decoder.decodeNode());
    }

    private static com.fasterxml.jackson.databind.JsonNode toJacksonNode(JsonNodeFactory factory, JsonNode mnNode) {
        if (mnNode.isArray()) {
            ArrayNode n = factory.arrayNode(mnNode.size());
            for (JsonNode value : mnNode.values()) {
                n.add(JacksonJsonNodeSerde.toJacksonNode(factory, value));
            }
            return n;
        }
        if (mnNode.isObject()) {
            ObjectNode n = factory.objectNode();
            for (Map.Entry entry : mnNode.entries()) {
                n.set((String)entry.getKey(), JacksonJsonNodeSerde.toJacksonNode(factory, (JsonNode)entry.getValue()));
            }
            return n;
        }
        if (mnNode.isNull()) {
            return factory.nullNode();
        }
        if (mnNode.isBoolean()) {
            return factory.booleanNode(mnNode.getBooleanValue());
        }
        if (mnNode.isString()) {
            return factory.textNode(mnNode.getStringValue());
        }
        Number numberValue = mnNode.getNumberValue();
        if (numberValue instanceof Integer) {
            return factory.numberNode(numberValue.intValue());
        }
        if (numberValue instanceof Long) {
            return factory.numberNode(numberValue.longValue());
        }
        if (numberValue instanceof Short) {
            return factory.numberNode(numberValue.shortValue());
        }
        if (numberValue instanceof Byte) {
            return factory.numberNode(numberValue.byteValue());
        }
        if (numberValue instanceof Float) {
            return factory.numberNode(numberValue.floatValue());
        }
        if (numberValue instanceof BigInteger) {
            BigInteger bi = (BigInteger)numberValue;
            return factory.numberNode(bi);
        }
        if (numberValue instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)numberValue;
            return factory.numberNode(bd);
        }
        return factory.numberNode(numberValue.doubleValue());
    }

    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends com.fasterxml.jackson.databind.JsonNode> type, @NonNull com.fasterxml.jackson.databind.JsonNode node) throws IOException {
        switch (node.getNodeType()) {
            case BOOLEAN: {
                encoder.encodeBoolean(node.booleanValue());
                break;
            }
            case NULL: {
                encoder.encodeNull();
                break;
            }
            case NUMBER: {
                JsonNodeSerde.encodeNumber(encoder, node.numberValue());
                break;
            }
            case STRING: {
                encoder.encodeString(node.textValue());
                break;
            }
            case BINARY: {
                encoder.encodeBinary(node.binaryValue());
                break;
            }
            case ARRAY: {
                try (Encoder array = encoder.encodeArray(JSON_NODE_ARGUMENT);){
                    for (com.fasterxml.jackson.databind.JsonNode member : node) {
                        this.serialize(array, context, type, member);
                    }
                    break;
                }
            }
            case OBJECT: {
                try (Encoder obj = encoder.encodeObject(JSON_NODE_ARGUMENT);){
                    for (String k : () -> ((com.fasterxml.jackson.databind.JsonNode)node).fieldNames()) {
                        obj.encodeKey(k);
                        this.serialize(encoder, context, type, node.get(k));
                    }
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Cannot serialize jackson-databind JsonNode of type " + node.getNodeType());
            }
        }
    }
}

