/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.NumericSupportTemporalSerde;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;

public final class LocalTimeSerde
extends NumericSupportTemporalSerde<LocalTime>
implements SerdeRegistrar<LocalTime> {
    public LocalTimeSerde(SerdeConfiguration configuration) {
        super(configuration, DateTimeFormatter.ISO_LOCAL_TIME, SerdeConfiguration.NumericTimeUnit.NANOSECONDS);
    }

    @Override
    public TemporalQuery<LocalTime> query() {
        return TemporalQueries.localTime();
    }

    @Override
    protected LocalTime fromNanos(long seconds, int nanos) {
        return LocalTime.ofSecondOfDay(seconds).withNano(nanos);
    }

    @Override
    protected long getSecondPart(LocalTime value) {
        return value.toSecondOfDay();
    }

    @Override
    protected int getNanoPart(LocalTime value) {
        return value.getNano();
    }

    @Override
    protected DefaultFormattedTemporalSerde<LocalTime> createSpecific(SerdeConfiguration configuration) {
        return new LocalTimeSerde(configuration);
    }

    @Override
    public Argument<LocalTime> getType() {
        return Argument.of(LocalTime.class);
    }
}

