/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.TimeZone;

@Internal
final class TimeZoneSerde
implements SerdeRegistrar<TimeZone> {
    TimeZoneSerde() {
    }

    @Override
    public Argument<TimeZone> getType() {
        return Argument.of(TimeZone.class);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends TimeZone> type, TimeZone value) throws IOException {
        encoder.encodeString(value.getID());
    }

    public TimeZone deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super TimeZone> type) throws IOException {
        return TimeZone.getTimeZone(decoder.decodeString());
    }

    public TimeZone deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super TimeZone> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }
}

