/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.reference.SerializationReference;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;

@Internal
final class CustomizedObjectSerializer<T>
implements ObjectSerializer<T> {
    private final SerBean<T> serBean;

    CustomizedObjectSerializer(SerBean<T> serBean) {
        this.serBean = serBean;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        Encoder childEncoder = encoder.encodeObject(type);
        this.serializeInto(childEncoder, context, type, value);
        childEncoder.finishStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        block9: for (SerBean.SerProperty property : this.serBean.writeProperties) {
            SerializationReference ref;
            Object propertyValue = property.get(value);
            String backRef = property.backRef;
            if (backRef != null && (ref = context.resolveReference(new SerializationReference(backRef, this.serBean.introspection, property.argument, propertyValue, property.serializer))) == null) continue;
            Serializer serializer = property.serializer;
            if (this.serBean.propertyFilter != null) {
                if (!this.serBean.propertyFilter.shouldInclude(context, serializer, value, property.name, propertyValue)) {
                    continue;
                }
            } else {
                switch (property.include) {
                    case NON_NULL: {
                        if (propertyValue != null) break;
                        continue block9;
                    }
                    case NON_ABSENT: {
                        if (!serializer.isAbsent(context, propertyValue)) break;
                        continue block9;
                    }
                    case NON_EMPTY: {
                        if (!serializer.isEmpty(context, propertyValue)) break;
                        continue block9;
                    }
                    case NEVER: {
                        continue block9;
                    }
                }
            }
            if (property.views != null && !context.hasView((Class[])property.views)) continue;
            String managedRef = property.managedRef;
            if (managedRef != null) {
                context.pushManagedRef((PropertyReference)new SerializationReference(managedRef, this.serBean.introspection, property.argument, value, property.serializer));
            }
            try {
                if (property.serializableInto) {
                    if (property.objectSerializer != null) {
                        property.objectSerializer.serializeInto(encoder, context, property.argument, propertyValue);
                        continue;
                    }
                    throw new SerdeException("Serializer for a property: " + property.name + " doesn't support serializing into an existing object");
                }
                encoder.encodeKey(property.name);
                if (propertyValue == null) {
                    encoder.encodeNull();
                    continue;
                }
                serializer.serialize(encoder, context, property.argument, propertyValue);
            }
            finally {
                if (managedRef == null) continue;
                context.popManagedRef();
            }
        }
    }
}

