/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;

@Singleton
@Requires(classes={HealthResult.class})
final class HealthResultDeserializer
implements CustomizableDeserializer<HealthResult> {
    private static final Argument<HealthResultDto> DELEGATE_ARGUMENT = Argument.of(HealthResultDto.class);

    HealthResultDeserializer() {
    }

    @NonNull
    public Deserializer<HealthResult> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super HealthResult> type) throws SerdeException {
        return new Impl((Deserializer<? extends HealthResultDto>)context.findDeserializer(DELEGATE_ARGUMENT).createSpecific(context, DELEGATE_ARGUMENT));
    }

    private record Impl(Deserializer<? extends HealthResultDto> delegate) implements Deserializer<HealthResult>
    {
        @Nullable
        public HealthResult deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super HealthResult> type) throws IOException {
            HealthResultDto dto = (HealthResultDto)this.delegate.deserialize(decoder, context, DELEGATE_ARGUMENT);
            assert (dto != null);
            HealthStatus status = switch (dto.status) {
                case "DOWN" -> HealthStatus.DOWN;
                case "UP" -> HealthStatus.UP;
                default -> new HealthStatus(dto.status);
            };
            return HealthResult.builder((String)dto.name).status(status).details(dto.details).build();
        }
    }

    @Serdeable
    record HealthResultDto(String name, String status, Map<String, Object> details) {
    }
}

