/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.deserializers.collect.CollectionDeserializer;
import java.io.IOException;
import java.util.TreeSet;

final class TreeSetDeserializer<E>
extends CollectionDeserializer<E, TreeSet<E>> {
    TreeSetDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        super(valueDeser, collectionItemArgument);
    }

    public TreeSet<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super TreeSet<E>> type) throws IOException {
        TreeSet collection = new TreeSet();
        this.doDeserialize(decoder, context, collection);
        return collection;
    }

    public TreeSet<E> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super TreeSet<E>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    public TreeSet<E> getDefaultValue(Deserializer.DecoderContext context, Argument<? super TreeSet<E>> type) {
        return new TreeSet();
    }
}

