/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.serdes.ObjectArraySerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.util.Map;

@Factory
@BootstrapContextCompatible
public class CoreSerdes {
    public static final Serde<Duration> DURATION_SERDE = new DurationSerde();
    public static final Serde<Period> PERIOD_SERDE = new PeriodSerde();
    public static final CharSequenceSerde CHAR_SEQUENCE_SERDE = new CharSequenceSerde();

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected Serde<Object[]> objectArraySerde() {
        return new ObjectArraySerde();
    }

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected Serde<Duration> durationSerde() {
        return DURATION_SERDE;
    }

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected Serde<Period> periodSerde() {
        return PERIOD_SERDE;
    }

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    @Order(value=100)
    protected Serde<CharSequence> charSequenceSerde() {
        return CHAR_SEQUENCE_SERDE;
    }

    @Singleton
    @NonNull
    @BootstrapContextCompatible
    protected Serde<JsonNode> jsonNodeSerde() {
        return new Serde<JsonNode>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends JsonNode> type, JsonNode value) throws IOException {
                this.serialize0(encoder, value);
            }

            private void serialize0(Encoder encoder, JsonNode value) throws IOException {
                if (value == null) {
                    value = JsonNode.nullNode();
                }
                if (value.isNull()) {
                    encoder.encodeNull();
                } else if (value.isBoolean()) {
                    encoder.encodeBoolean(value.getBooleanValue());
                } else if (value.isString()) {
                    encoder.encodeString(value.getStringValue());
                } else if (value.isNumber()) {
                    Number numberValue = value.getNumberValue();
                    if (numberValue instanceof Integer || numberValue instanceof Byte || numberValue instanceof Short || numberValue instanceof Long) {
                        encoder.encodeLong(numberValue.longValue());
                    } else if (numberValue instanceof BigInteger) {
                        BigInteger bi = (BigInteger)numberValue;
                        encoder.encodeBigInteger(bi);
                    } else if (numberValue instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)numberValue;
                        encoder.encodeBigDecimal(bd);
                    } else {
                        encoder.encodeDouble(numberValue.doubleValue());
                    }
                } else if (value.isObject()) {
                    Encoder objectEncoder = encoder.encodeObject(Argument.of(JsonNode.class));
                    for (Map.Entry entry : value.entries()) {
                        objectEncoder.encodeKey((String)entry.getKey());
                        this.serialize0(encoder, (JsonNode)entry.getValue());
                    }
                    objectEncoder.finishStructure();
                } else if (value.isArray()) {
                    Encoder arrayEncoder = encoder.encodeArray(Argument.of(JsonNode.class));
                    for (JsonNode entry : value.values()) {
                        this.serialize0(encoder, entry);
                    }
                    arrayEncoder.finishStructure();
                } else {
                    throw new IllegalArgumentException("Unsupported JSON node");
                }
            }

            public JsonNode deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super JsonNode> type) throws IOException {
                return decoder.decodeNode();
            }
        };
    }

    private static final class CharSequenceSerde
    implements Serde<CharSequence> {
        private CharSequenceSerde() {
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends CharSequence> type, CharSequence value) throws IOException {
            encoder.encodeString(value.toString());
        }

        public CharSequence deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super CharSequence> type) throws IOException {
            return decoder.decodeString();
        }

        public CharSequence deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super CharSequence> type) throws IOException {
            return decoder.decodeStringNullable();
        }
    }

    private static class DurationSerde
    implements Serde<Duration> {
        private DurationSerde() {
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Duration> type, Duration value) throws IOException {
            encoder.encodeLong(value.toNanos());
        }

        public Duration deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Duration> type) throws IOException {
            return Duration.ofNanos(decoder.decodeLong());
        }
    }

    private static class PeriodSerde
    implements Serde<Period> {
        private PeriodSerde() {
        }

        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Period> type, Period value) throws IOException {
            encoder.encodeString(value.toString());
        }

        public Period deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Period> type) throws IOException {
            return Period.parse(decoder.decodeString());
        }
    }
}

