/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.NumericSupportTemporalSerde;
import jakarta.inject.Singleton;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;

@Singleton
public final class LocalTimeSerde
extends NumericSupportTemporalSerde<LocalTime> {
    LocalTimeSerde(SerdeConfiguration configuration) {
        super(configuration, DateTimeFormatter.ISO_LOCAL_TIME, SerdeConfiguration.NumericTimeUnit.NANOSECONDS);
    }

    @Override
    public TemporalQuery<LocalTime> query() {
        return TemporalQueries.localTime();
    }

    @Override
    protected LocalTime fromNanos(long seconds, int nanos) {
        return LocalTime.ofSecondOfDay(seconds).withNano(nanos);
    }

    @Override
    protected long getSecondPart(LocalTime value) {
        return value.toSecondOfDay();
    }

    @Override
    protected int getNanoPart(LocalTime value) {
        return value.getNano();
    }
}

