/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.serializers.CustomizedMapSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;

@Factory
public final class CoreSerializers {
    @Singleton
    Serializer<CharSequence> charSequenceSerializer() {
        return new Serializer<CharSequence>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends CharSequence> type, CharSequence value) throws IOException {
                if (value instanceof String) {
                    encoder.encodeString((String)value);
                } else {
                    encoder.encodeString(value.toString());
                }
            }

            public boolean isEmpty(Serializer.EncoderContext context, CharSequence value) {
                return value == null || value.length() == 0;
            }
        };
    }

    @Singleton
    @Order(value=1000)
    Serializer<String> stringSerializer() {
        return new Serializer<String>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends String> type, String value) throws IOException {
                encoder.encodeString(value);
            }

            public boolean isEmpty(Serializer.EncoderContext context, String value) {
                return value == null || value.length() == 0;
            }
        };
    }

    @Singleton
    Serializer<Character> charSerializer() {
        return (encoder, context, type, value) -> encoder.encodeChar(value.charValue());
    }

    @Singleton
    Serializer<Boolean> booleanSerializer() {
        return (encoder, context, type, value) -> encoder.encodeBoolean(value.booleanValue());
    }

    @Singleton
    <K, V> Serializer<Map<K, V>> mapSerializer() {
        return new CustomizedMapSerializer();
    }
}

