/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Map;

final class CustomizedMapSerializer<K, V>
implements CustomizableSerializer<Map<K, V>> {
    CustomizedMapSerializer() {
    }

    public Serializer<Map<K, V>> createSpecific(Serializer.EncoderContext context, Argument<? extends Map<K, V>> type) throws SerdeException {
        boolean hasGenerics;
        Object[] generics = type.getTypeParameters();
        boolean bl = hasGenerics = ArrayUtils.isNotEmpty((Object[])generics) && generics.length != 2;
        if (hasGenerics) {
            Object valueGeneric = generics[1];
            final Serializer valSerializer = context.findSerializer((Argument)valueGeneric).createSpecific(context, (Argument)valueGeneric);
            return new Serializer<Map<K, V>>(){
                final /* synthetic */ Argument val$valueGeneric;
                {
                    this.val$valueGeneric = argument;
                }

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    Encoder childEncoder = encoder.encodeObject(type);
                    for (Object k : value.keySet()) {
                        CustomizedMapSerializer.this.encodeMapKey(context, childEncoder, k);
                        Object v = value.get(k);
                        if (v == null) {
                            childEncoder.encodeNull();
                            continue;
                        }
                        valSerializer.serialize(childEncoder, context, this.val$valueGeneric, v);
                    }
                    childEncoder.finishStructure();
                }

                public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                    return CollectionUtils.isEmpty(value);
                }
            };
        }
        return new Serializer<Map<K, V>>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                Encoder childEncoder = encoder.encodeObject(type);
                for (Map.Entry entry : value.entrySet()) {
                    CustomizedMapSerializer.this.encodeMapKey(context, childEncoder, entry.getKey());
                    Object v = entry.getValue();
                    if (v == null) {
                        childEncoder.encodeNull();
                        continue;
                    }
                    Argument valueGeneric = Argument.of(v.getClass());
                    Serializer valSerializer = context.findSerializer(valueGeneric).createSpecific(context, valueGeneric);
                    valSerializer.serialize(childEncoder, context, valueGeneric, v);
                }
                childEncoder.finishStructure();
            }

            public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                return CollectionUtils.isEmpty(value);
            }
        };
    }

    private void encodeMapKey(Serializer.EncoderContext context, Encoder childEncoder, K k) throws IOException {
        if (k instanceof CharSequence) {
            childEncoder.encodeKey(k.toString());
        } else {
            try {
                String result = (String)context.getConversionService().convertRequired(k, Argument.STRING);
                childEncoder.encodeKey(result != null ? result : k.toString());
            }
            catch (ConversionErrorException e) {
                throw new SerdeException("Error converting Map key [" + k + "] to String: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

