/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Singleton
final class OptionalMultiValuesSerializer<V>
implements CustomizableSerializer<OptionalMultiValues<V>> {
    private final boolean alwaysSerializeErrorsAsList;

    public OptionalMultiValuesSerializer(SerializationConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    public Serializer<OptionalMultiValues<V>> createSpecific(Serializer.EncoderContext context, Argument<? extends OptionalMultiValues<V>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot serialize raw OptionalMultiValues");
        }
        Object generic = generics[0];
        final Argument listGeneric = Argument.listOf((Argument)generic);
        final Serializer listSerializer = context.findSerializer(listGeneric).createSpecific(context, listGeneric);
        final Serializer valueSerializer = context.findSerializer((Argument)generic).createSpecific(context, (Argument)generic);
        return new Serializer<OptionalMultiValues<V>>(){
            final /* synthetic */ Argument val$generic;
            {
                this.val$generic = argument2;
            }

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalMultiValues<V>> type, OptionalMultiValues<V> value) throws IOException {
                Objects.requireNonNull(value, "Values can't be null");
                Encoder objectEncoder = encoder.encodeObject(type);
                for (CharSequence key : value) {
                    Optional opt = value.get(key);
                    if (!opt.isPresent()) continue;
                    String fieldName = key.toString();
                    objectEncoder.encodeKey(fieldName);
                    List list = (List)opt.get();
                    if (OptionalMultiValuesSerializer.this.alwaysSerializeErrorsAsList) {
                        listSerializer.serialize(objectEncoder, context, listGeneric, (Object)list);
                        continue;
                    }
                    if (list.size() == 1) {
                        valueSerializer.serialize(objectEncoder, context, this.val$generic, list.get(0));
                        continue;
                    }
                    listSerializer.serialize(objectEncoder, context, listGeneric, (Object)list);
                }
                objectEncoder.finishStructure();
            }

            public boolean isEmpty(Serializer.EncoderContext context, OptionalMultiValues<V> value) {
                return value == null || value.isEmpty();
            }
        };
    }
}

