/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.serde.PropertyFilter;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.util.SerdeAnnotationUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

@Internal
final class SerBean<T> {
    private static final Comparator<BeanProperty<?, Object>> BEAN_PROPERTY_COMPARATOR = (o1, o2) -> OrderUtil.COMPARATOR.compare(new Ordered((BeanProperty)o1){
        final /* synthetic */ BeanProperty val$o1;
        {
            this.val$o1 = beanProperty;
        }

        public int getOrder() {
            return this.val$o1.intValue(Order.class).orElse(0);
        }
    }, new Ordered((BeanProperty)o2){
        final /* synthetic */ BeanProperty val$o2;
        {
            this.val$o2 = beanProperty;
        }

        public int getOrder() {
            return this.val$o2.intValue(Order.class).orElse(0);
        }
    });
    private static final String JK_PROP = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final String JACKSON_VALUE = "com.fasterxml.jackson.annotation.JsonValue";
    @NonNull
    public final BeanIntrospection<T> introspection;
    public final List<SerProperty<T, Object>> writeProperties;
    @Nullable
    public final String wrapperProperty;
    @Nullable
    public SerProperty<T, Object> anyGetter;
    public SerProperty<T, Object> jsonValue;
    public final SerializationConfiguration configuration;
    public final boolean simpleBean;
    public final boolean subtyped;
    public final PropertyFilter propertyFilter;
    private volatile boolean initialized;
    private volatile boolean initializing;
    private List<Initializer> initializers = new ArrayList<Initializer>();

    SerBean(Argument<T> definition, SerdeIntrospections introspections, Serializer.EncoderContext encoderContext, SerializationConfiguration configuration, BeanContext beanContext) throws SerdeException {
        this.configuration = configuration;
        AnnotationMetadata annotationMetadata = definition.getAnnotationMetadata();
        this.introspection = introspections.getSerializableIntrospection(definition);
        this.propertyFilter = this.getPropertyFilterIfPresent(beanContext, definition.getSimpleName());
        PropertyNamingStrategy entityPropertyNamingStrategy = this.getPropertyNamingStrategy((AnnotationMetadata)this.introspection, encoderContext, null);
        Collection properties = this.introspection.getBeanProperties().stream().filter(property -> !property.isWriteOnly() && property.booleanValue(SerdeConfig.class, "ignored").orElse(false) == false && property.booleanValue(SerdeConfig.class, "readOnly").orElse(false) == false).sorted(this.getPropertyComparator()).map(beanProperty -> {
            Optional<Argument> constructorArgument = Arrays.stream(this.introspection.getConstructor().getArguments()).filter(a -> a.getName().equals(beanProperty.getName()) && a.getType().equals(beanProperty.getType())).findFirst();
            return constructorArgument.map(argument -> new AbstractMap.SimpleEntry<BeanProperty, AnnotationMetadataHierarchy>((BeanProperty)beanProperty, new AnnotationMetadataHierarchy(new AnnotationMetadata[]{argument.getAnnotationMetadata(), beanProperty.getAnnotationMetadata()}))).orElseGet(() -> new AbstractMap.SimpleEntry<BeanProperty, AnnotationMetadata>((BeanProperty)beanProperty, beanProperty.getAnnotationMetadata()));
        }).collect(Collectors.toList());
        Map.Entry serPropEntry = properties.stream().filter(bp -> ((AnnotationMetadata)bp.getValue()).hasAnnotation(SerdeConfig.SerValue.class) || ((AnnotationMetadata)bp.getValue()).hasAnnotation(JACKSON_VALUE)).findFirst().orElse(null);
        if (serPropEntry != null) {
            this.wrapperProperty = null;
            BeanProperty beanProperty2 = (BeanProperty)serPropEntry.getKey();
            Argument serType = beanProperty2.asArgument();
            AnnotationMetadata propertyAnnotationMetadata = (AnnotationMetadata)serPropEntry.getValue();
            this.jsonValue = new PropSerProperty<T, Object>(this, beanProperty2.getName(), serType, propertyAnnotationMetadata, beanProperty2);
            this.initializers.add(ctx -> this.initProperty(this.jsonValue, ctx));
            this.writeProperties = Collections.emptyList();
        } else {
            Collection beanMethods = this.introspection.getBeanMethods();
            BeanMethod serMethod = beanMethods.stream().filter(m -> m.isAnnotationPresent(SerdeConfig.SerValue.class) || m.getAnnotationMetadata().hasAnnotation(JACKSON_VALUE)).findFirst().orElse(null);
            if (serMethod != null) {
                this.wrapperProperty = null;
                Argument serType = serMethod.getReturnType().asArgument();
                this.jsonValue = new MethodSerProperty<T, Object>(this, serMethod.getName(), serType, serMethod.getAnnotationMetadata(), serMethod);
                this.initializers.add(ctx -> this.initProperty(this.jsonValue, ctx));
                this.writeProperties = Collections.emptyList();
            } else {
                ArrayList<BeanMethod> jsonGetters = new ArrayList<BeanMethod>(beanMethods.size());
                BeanMethod anyGetter = null;
                for (BeanMethod beanMethod : beanMethods) {
                    if (beanMethod.isAnnotationPresent(SerdeConfig.SerGetter.class)) {
                        jsonGetters.add(beanMethod);
                        continue;
                    }
                    if (!beanMethod.isAnnotationPresent(SerdeConfig.SerAnyGetter.class)) continue;
                    anyGetter = beanMethod;
                }
                this.anyGetter = anyGetter != null ? new MethodSerProperty(this, "any", anyGetter.getReturnType().asArgument(), anyGetter.getAnnotationMetadata(), anyGetter) : null;
                SerProperty<T, Object> ag = this.anyGetter;
                if (ag != null) {
                    this.initializers.add(ctx -> this.initProperty(ag, ctx));
                }
                if (!properties.isEmpty() || !jsonGetters.isEmpty()) {
                    this.writeProperties = new ArrayList<SerProperty<T, Object>>(properties.size() + jsonGetters.size());
                    AnnotationMetadataHierarchy am = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.introspection, definition.getAnnotationMetadata()});
                    am.stringValue(SerdeConfig.class, "typeName").ifPresent(arg_0 -> this.lambda$new$13((AnnotationMetadata)am, arg_0));
                    for (Map.Entry propWithAnnotations : properties) {
                        BeanProperty property2 = (BeanProperty)propWithAnnotations.getKey();
                        Argument argument = property2.asArgument();
                        AnnotationMetadata propertyAnnotationMetadata = (AnnotationMetadata)propWithAnnotations.getValue();
                        String defaultPropertyName = argument.getName();
                        boolean unwrapped = propertyAnnotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
                        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(property2.getAnnotationMetadata(), encoderContext, entityPropertyNamingStrategy);
                        if (unwrapped) {
                            this.processUnwrapped(introspections, property2, (Argument<Object>)argument, propertyAnnotationMetadata, propertyNamingStrategy, null);
                            continue;
                        }
                        String n = this.resolveName(annotationMetadata, propertyAnnotationMetadata, defaultPropertyName, false, propertyNamingStrategy);
                        PropSerProperty<T, Object> serProperty = new PropSerProperty<T, Object>(this, n, argument, propertyAnnotationMetadata, property2);
                        this.initializers.add(ctx -> {
                            try {
                                this.initProperty(serProperty, ctx);
                            }
                            catch (SerdeException e) {
                                throw new SerdeException("Error resolving serializer for property [" + property2 + "] of type [" + argument.getType().getName() + "]: " + e.getMessage(), (Throwable)e);
                            }
                        });
                        if (propertyAnnotationMetadata.hasDeclaredAnnotation(SerdeConfig.SerAnyGetter.class)) {
                            this.anyGetter = serProperty;
                            continue;
                        }
                        this.writeProperties.add(serProperty);
                    }
                    for (BeanMethod jsonGetter : jsonGetters) {
                        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(jsonGetter.getAnnotationMetadata(), encoderContext, entityPropertyNamingStrategy);
                        AnnotationMetadata jsonGetterAnnotationMetadata = jsonGetter.getAnnotationMetadata();
                        String propertyName = NameUtils.getPropertyNameForGetter((String)jsonGetter.getName());
                        String n = this.resolveName(annotationMetadata, jsonGetterAnnotationMetadata, propertyName, false, propertyNamingStrategy);
                        Argument returnType = jsonGetter.getReturnType().asArgument();
                        MethodSerProperty prop = new MethodSerProperty(this, n, returnType, jsonGetterAnnotationMetadata, jsonGetter);
                        this.writeProperties.add(prop);
                        this.initializers.add(ctx -> this.initProperty(prop, ctx));
                    }
                } else {
                    this.writeProperties = Collections.emptyList();
                }
                this.wrapperProperty = this.introspection.stringValue(SerdeConfig.class, "wrapperProperty").orElse(null);
            }
        }
        this.simpleBean = this.isSimpleBean();
        boolean isAbstractIntrospection = Modifier.isAbstract(this.introspection.getBeanType().getModifiers());
        this.subtyped = isAbstractIntrospection || this.introspection.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class);
    }

    private void processUnwrapped(SerdeIntrospections introspections, BeanProperty<T, Object> property, Argument<Object> argument, AnnotationMetadata propertyAnnotationMetadata, PropertyNamingStrategy propertyNamingStrategy, Function<T, Object> nestedValueResolver) {
        BeanIntrospection propertyIntrospection = introspections.getSerializableIntrospection(property.asArgument());
        Set ignoredProperties = Arrays.stream(argument.getAnnotationMetadata().stringValues(SerdeConfig.SerIgnored.class)).collect(Collectors.toSet());
        for (BeanProperty unwrappedProperty : propertyIntrospection.getBeanProperties()) {
            if (ignoredProperties.contains(unwrappedProperty.getName())) continue;
            Argument unwrappedPropertyArgument = unwrappedProperty.asArgument();
            AnnotationMetadata unwrappedPropertyAnnotationMetadata = unwrappedProperty.getAnnotationMetadata();
            Function<Object, Object> valueResolver = nestedValueResolver != null ? bean -> unwrappedProperty.get(nestedValueResolver.apply(bean)) : bean -> unwrappedProperty.get(property.get(bean));
            String n = this.resolveName(propertyAnnotationMetadata, unwrappedPropertyAnnotationMetadata, unwrappedPropertyArgument.getName(), true, propertyNamingStrategy);
            AnnotationMetadataHierarchy combinedMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{argument.getAnnotationMetadata(), unwrappedPropertyAnnotationMetadata});
            if (unwrappedPropertyAnnotationMetadata.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                this.processUnwrapped(introspections, unwrappedProperty, (Argument<Object>)unwrappedPropertyArgument, (AnnotationMetadata)combinedMetadata, propertyNamingStrategy, valueResolver);
                continue;
            }
            if (combinedMetadata.booleanValue(SerdeConfig.class, "ignored").orElse(false).booleanValue() || combinedMetadata.booleanValue(SerdeConfig.class, "readOnly").orElse(false).booleanValue()) continue;
            CustomSerProperty<Object, Object> prop = new CustomSerProperty<Object, Object>(this, n, unwrappedPropertyArgument, (AnnotationMetadata)combinedMetadata, valueResolver);
            this.writeProperties.add(prop);
            this.initializers.add(ctx -> this.initProperty(prop, ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Serializer.EncoderContext encoderContext) throws SerdeException {
        if (!this.initialized) {
            SerBean serBean = this;
            synchronized (serBean) {
                if (!this.initialized && !this.initializing) {
                    this.initializing = true;
                    for (Initializer initializer : this.initializers) {
                        initializer.initialize(encoderContext);
                    }
                    this.initializers = null;
                    this.initialized = true;
                    this.initializing = false;
                }
            }
        }
    }

    private <Y, Z> void initProperty(SerProperty<Y, Z> prop, Serializer.EncoderContext encoderContext) throws SerdeException {
        if (prop.serializer != null) {
            return;
        }
        prop.serializer = this.findSerializer(encoderContext, prop.argument, prop.annotationMetadata);
        prop.annotationMetadata = null;
    }

    private boolean isSimpleBean() {
        if (this.wrapperProperty != null || this.anyGetter != null) {
            return false;
        }
        if (this.propertyFilter != null) {
            return false;
        }
        for (SerProperty<T, Object> property : this.writeProperties) {
            if (property.backRef == null && property.include == SerdeConfig.SerInclude.ALWAYS && property.views == null && property.managedRef == null) continue;
            return false;
        }
        return true;
    }

    public boolean hasJsonValue() {
        return this.jsonValue != null;
    }

    private PropertyNamingStrategy getPropertyNamingStrategy(AnnotationMetadata annotationMetadata, Serializer.EncoderContext encoderContext, PropertyNamingStrategy defaultNamingStrategy) throws SerdeException {
        Class namingStrategyClass = annotationMetadata.classValue(SerdeConfig.class, "runtimeNaming").orElse(null);
        return namingStrategyClass == null ? defaultNamingStrategy : encoderContext.findNamingStrategy(namingStrategyClass);
    }

    private Comparator<BeanProperty<?, Object>> getPropertyComparator() {
        return BEAN_PROPERTY_COMPARATOR;
    }

    private <K> Serializer<K> findSerializer(Serializer.EncoderContext encoderContext, Argument<K> argument, AnnotationMetadata annotationMetadata) throws SerdeException {
        Class customSer = annotationMetadata.classValue(SerdeConfig.class, "serializerClass").orElse(null);
        if (customSer != null) {
            return encoderContext.findCustomSerializer(customSer).createSpecific(encoderContext, argument);
        }
        return encoderContext.findSerializer(argument).createSpecific(encoderContext, argument);
    }

    private String resolveName(AnnotationMetadata annotationMetadata, final AnnotationMetadata propertyAnnotationMetadata, final String defaultPropertyName, boolean unwrapped, PropertyNamingStrategy propertyNamingStrategy) {
        String n;
        String string = n = propertyNamingStrategy == null ? (String)propertyAnnotationMetadata.stringValue(SerdeConfig.class, "property").orElse(null) : propertyNamingStrategy.translate(new AnnotatedElement(){

            public String getName() {
                return defaultPropertyName;
            }

            public AnnotationMetadata getAnnotationMetadata() {
                return propertyAnnotationMetadata;
            }
        });
        if (n == null) {
            n = propertyAnnotationMetadata.stringValue(JK_PROP).orElse(defaultPropertyName);
        }
        if (unwrapped) {
            @NonNull Object[] prefixes = annotationMetadata.stringValues(SerdeConfig.SerUnwrapped.class, "prefix");
            @NonNull Object[] suffixes = annotationMetadata.stringValues(SerdeConfig.SerUnwrapped.class, "suffix");
            if (ArrayUtils.isNotEmpty((Object[])prefixes) || ArrayUtils.isNotEmpty((Object[])suffixes)) {
                List<@NonNull Object> prefixList = Arrays.asList(prefixes);
                Collections.reverse(prefixList);
                List<@NonNull Object> suffixList = Arrays.asList(suffixes);
                return String.join((CharSequence)"", prefixList) + n + String.join((CharSequence)"", suffixList);
            }
        }
        return n;
    }

    private PropertyFilter getPropertyFilterIfPresent(BeanContext beanContext, String typeName) {
        Optional filterName = this.introspection.stringValue(SerdeConfig.class, "filter");
        if (filterName.isPresent() && !((String)filterName.get()).isEmpty()) {
            return beanContext.findBean(PropertyFilter.class, Qualifiers.byName((String)((String)filterName.get()))).orElseGet(() -> {
                LoggerFactory.getLogger(SerBean.class).warn("Json filter with name '{}' was defined on type {} but no PropertyFilter bean with the name exists", filterName.get(), (Object)typeName);
                return null;
            });
        }
        return null;
    }

    private /* synthetic */ void lambda$new$13(AnnotationMetadata am, String typeName) {
        String typeProperty = am.stringValue(SerdeConfig.class, "typeProperty").orElse(null);
        if (typeProperty != null) {
            SerProperty prop = "$CLASS_SIMPLE_NAME".equals(typeName) ? new CustomSerProperty<Object, String>(this, typeProperty, Argument.of(String.class, (String)typeProperty), t -> t.getClass().getSimpleName()) : new InjectedSerProperty(this, typeProperty, Argument.of(String.class, (String)typeProperty), typeName);
            this.writeProperties.add(prop);
            this.initializers.add(context -> {
                try {
                    this.initProperty(prop, context);
                }
                catch (SerdeException e) {
                    throw new IntrospectionException("Error configuring subtype binding for type " + this.introspection.getBeanType() + ": " + e.getMessage());
                }
            });
        }
    }

    static final class PropSerProperty<B, P>
    extends SerProperty<B, P> {
        private final UnsafeBeanProperty<B, P> beanProperty;

        public PropSerProperty(SerBean<B> bean, String name, Argument<P> argument, AnnotationMetadata annotationMetadata, BeanProperty<B, P> beanProperty) {
            super(bean, name, argument, annotationMetadata);
            this.beanProperty = (UnsafeBeanProperty)beanProperty;
        }

        @Override
        public P get(B bean) {
            return (P)this.beanProperty.getUnsafe(bean);
        }
    }

    @Internal
    static abstract class SerProperty<B, P> {
        public final String name;
        public final Argument<P> argument;
        public final Class<?>[] views;
        public final String managedRef;
        public final String backRef;
        public final SerdeConfig.SerInclude include;
        public Serializer<P> serializer;
        public AnnotationMetadata annotationMetadata;

        public SerProperty(SerBean<B> bean, @NonNull String name, @NonNull Argument<P> argument) {
            this(bean, name, argument, argument.getAnnotationMetadata());
        }

        public SerProperty(SerBean<B> bean, @NonNull String name, @NonNull Argument<P> argument, @NonNull AnnotationMetadata annotationMetadata) {
            this.name = name;
            this.argument = argument;
            AnnotationMetadata beanMetadata = bean.introspection.getAnnotationMetadata();
            AnnotationMetadata hierarchy = annotationMetadata.isEmpty() ? beanMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{beanMetadata, annotationMetadata});
            this.views = SerdeAnnotationUtil.resolveViews(beanMetadata, annotationMetadata);
            this.include = hierarchy.enumValue(SerdeConfig.class, "include", SerdeConfig.SerInclude.class).orElse(bean.configuration.getInclusion());
            this.managedRef = annotationMetadata.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            this.backRef = annotationMetadata.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            this.annotationMetadata = annotationMetadata;
        }

        public abstract P get(B var1);
    }

    private static interface Initializer {
        public void initialize(Serializer.EncoderContext var1) throws SerdeException;
    }

    static final class MethodSerProperty<B, P>
    extends SerProperty<B, P> {
        private final BeanMethod<B, P> beanMethod;

        public MethodSerProperty(SerBean<B> bean, String name, Argument<P> argument, AnnotationMetadata annotationMetadata, BeanMethod<B, P> beanMethod) {
            super(bean, name, argument, annotationMetadata);
            this.beanMethod = beanMethod;
        }

        @Override
        public P get(B bean) {
            return (P)this.beanMethod.invoke(bean, new Object[0]);
        }
    }

    static final class CustomSerProperty<B, P>
    extends SerProperty<B, P> {
        private final Function<B, P> reader;

        public CustomSerProperty(SerBean<B> bean, String name, Argument<P> argument, Function<B, P> reader) {
            super(bean, name, argument);
            this.reader = reader;
        }

        public CustomSerProperty(SerBean<B> bean, String name, Argument<P> argument, AnnotationMetadata annotationMetadata, Function<B, P> reader) {
            super(bean, name, argument, annotationMetadata);
            this.reader = reader;
        }

        @Override
        public P get(B bean) {
            return this.reader.apply(bean);
        }
    }

    static final class InjectedSerProperty<B, P>
    extends SerProperty<B, P> {
        private final P injected;

        public InjectedSerProperty(SerBean<B> bean, String name, Argument<P> argument, P injected) {
            super(bean, name, argument);
            this.injected = injected;
        }

        @Override
        public P get(B bean) {
            return this.injected;
        }
    }
}

