/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.attr.MutableAttributeHolder;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentValue;
import io.micronaut.core.type.Executable;
import io.micronaut.core.type.MutableArgumentValue;
import java.util.LinkedHashMap;
import java.util.Map;

public interface InvocationContext<T, R>
extends Executable<T, R>,
AnnotationMetadataDelegate,
MutableAttributeHolder {
    @NonNull
    public Map<String, MutableArgumentValue<?>> getParameters();

    @NonNull
    public T getTarget();

    @Nullable
    public R proceed() throws RuntimeException;

    @Nullable
    public R proceed(Interceptor var1) throws RuntimeException;

    @NonNull
    default public InterceptorKind getKind() {
        return InterceptorKind.AROUND;
    }

    @Override
    default public Class<T> getDeclaringType() {
        return this.getTarget().getClass();
    }

    @Override
    default public InvocationContext<T, R> setAttribute(@NonNull CharSequence name, Object value) {
        return (InvocationContext)MutableAttributeHolder.super.setAttribute(name, value);
    }

    @NonNull
    default public Object[] getParameterValues() {
        return this.getParameters().values().stream().map(ArgumentValue::getValue).toArray();
    }

    @NonNull
    default public Map<String, Object> getParameterValueMap() {
        Argument<?>[] arguments = this.getArguments();
        Object[] parameterValues = this.getParameterValues();
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(arguments.length);
        for (int i = 0; i < parameterValues.length; ++i) {
            Object parameterValue = parameterValues[i];
            Argument<?> arg = arguments[i];
            valueMap.put(arg.getName(), parameterValue);
        }
        return valueMap;
    }
}

