/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public interface ApplicationContext
extends BeanContext,
PropertyResolver,
PropertyPlaceholderResolver {
    @NonNull
    public Environment getEnvironment();

    @Override
    @NonNull
    public ApplicationContext start();

    @Override
    @NonNull
    public ApplicationContext stop();

    @Override
    @NonNull
    public <T> ApplicationContext registerSingleton(@NonNull Class<T> var1, @NonNull T var2, @Nullable Qualifier<T> var3, boolean var4);

    @Override
    @NonNull
    default public <T> ApplicationContext registerSingleton(@NonNull Class<T> type, @NonNull T singleton, @Nullable Qualifier<T> qualifier) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, true);
    }

    @Override
    @NonNull
    default public <T> ApplicationContext registerSingleton(@NonNull Class<T> type, @NonNull T singleton) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)null, true);
    }

    @Override
    @NonNull
    default public ApplicationContext registerSingleton(@NonNull Object singleton, boolean inject) {
        return (ApplicationContext)BeanContext.super.registerSingleton(singleton, inject);
    }

    @NonNull
    default public ApplicationContext environment(@NonNull Consumer<Environment> consumer) {
        ArgumentUtils.requireNonNull("consumer", consumer);
        consumer.accept(this.getEnvironment());
        return this;
    }

    @Override
    @NonNull
    default public ApplicationContext registerSingleton(@NonNull Object singleton) {
        ArgumentUtils.requireNonNull("singleton", singleton);
        Class<?> type = singleton.getClass();
        return this.registerSingleton((Class)type, singleton);
    }

    @NonNull
    public static ApplicationContext run(String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        return ApplicationContext.builder(environments).start();
    }

    @NonNull
    public static ApplicationContext run() {
        return ApplicationContext.run(StringUtils.EMPTY_STRING_ARRAY);
    }

    @NonNull
    public static ApplicationContext run(@NonNull Map<String, Object> properties, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("properties", properties);
        PropertySource propertySource = PropertySource.of("context", properties, 0);
        return ApplicationContext.run(propertySource, environments);
    }

    @NonNull
    public static ApplicationContext run(@NonNull PropertySource properties, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("properties", properties);
        return ApplicationContext.builder(environments).propertySources(properties).start();
    }

    @NonNull
    public static <T extends AutoCloseable> T run(@NonNull Class<T> type, String ... environments) {
        ArgumentUtils.requireNonNull("type", type);
        ArgumentUtils.requireNonNull("environments", environments);
        return ApplicationContext.run(type, Collections.emptyMap(), environments);
    }

    @NonNull
    public static <T extends AutoCloseable> T run(@NonNull Class<T> type, @NonNull Map<String, Object> properties, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("properties", properties);
        ArgumentUtils.requireNonNull("type", type);
        PropertySource propertySource = PropertySource.of("context", properties, 0);
        return ApplicationContext.run(type, propertySource, environments);
    }

    @NonNull
    public static <T extends AutoCloseable> T run(@NonNull Class<T> type, @NonNull PropertySource propertySource, String ... environments) {
        LifeCycle lifeCycle;
        ArgumentUtils.requireNonNull("propertySource", propertySource);
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("type", type);
        AutoCloseable bean = (AutoCloseable)ApplicationContext.builder(environments).mainClass(type).propertySources(propertySource).start().getBean(type);
        if (bean instanceof LifeCycle && !(lifeCycle = (LifeCycle)bean).isRunning()) {
            lifeCycle.start();
        }
        return (T)bean;
    }

    @NonNull
    public static ApplicationContextBuilder builder(String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        return ApplicationContext.builder().environments(environments);
    }

    @NonNull
    public static ApplicationContextBuilder builder(@NonNull Map<String, Object> properties, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("properties", properties);
        return ApplicationContext.builder().properties(properties).environments(environments);
    }

    @NonNull
    public static ApplicationContextBuilder builder() {
        return new DefaultApplicationContextBuilder();
    }

    @NonNull
    public static ApplicationContextBuilder builder(ClassLoader classLoader) {
        return new DefaultApplicationContextBuilder(classLoader);
    }

    @NonNull
    public static ApplicationContext run(@NonNull ClassLoader classLoader, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("classLoader", classLoader);
        return ApplicationContext.builder(classLoader, environments).start();
    }

    @NonNull
    public static ApplicationContextBuilder builder(@NonNull ClassLoader classLoader, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("classLoader", classLoader);
        return ApplicationContext.builder(classLoader).environments(environments);
    }

    @NonNull
    public static ApplicationContextBuilder builder(@NonNull Class<?> mainClass, String ... environments) {
        ArgumentUtils.requireNonNull("environments", environments);
        ArgumentUtils.requireNonNull("mainClass", mainClass);
        return ApplicationContext.builder(environments).mainClass(mainClass);
    }
}

