/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;

@Internal
final class EnvironmentAwareArgument<T>
extends DefaultArgument<T>
implements EnvironmentConfigurable {
    private final AnnotationMetadata annotationMetadata;
    private Environment environment;

    EnvironmentAwareArgument(DefaultArgument<T> argument) {
        super(argument.getType(), argument.getName(), argument.getAnnotationMetadata(), argument.getTypeVariables(), argument.getTypeParameters());
        this.annotationMetadata = this.initAnnotationMetadata(argument.getAnnotationMetadata());
    }

    @Override
    public boolean hasPropertyExpressions() {
        return this.annotationMetadata.hasPropertyExpressions();
    }

    @Override
    public void configure(Environment environment) {
        this.environment = environment;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    private AnnotationMetadata initAnnotationMetadata(@Nullable AnnotationMetadata annotationMetadata) {
        if (annotationMetadata instanceof DefaultAnnotationMetadata && annotationMetadata.hasPropertyExpressions()) {
            return new ArgumentAnnotationMetadata((DefaultAnnotationMetadata)annotationMetadata);
        }
        if (annotationMetadata != null) {
            return annotationMetadata;
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private final class ArgumentAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        ArgumentAnnotationMetadata(DefaultAnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return EnvironmentAwareArgument.this.environment;
        }
    }
}

