/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import groovy.lang.GroovySystem;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.OperatingSystem;
import io.micronaut.context.condition.TrueCondition;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.version.SemanticVersion;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.KotlinVersion;

public class RequiresCondition
implements Condition {
    public static final String MEMBER_PROPERTY = "property";
    public static final String MEMBER_NOT_EQUALS = "notEquals";
    public static final String MEMBER_DEFAULT_VALUE = "defaultValue";
    public static final String MEMBER_PATTERN = "pattern";
    public static final String MEMBER_MISSING_PROPERTY = "missingProperty";
    public static final String MEMBER_ENV = "env";
    public static final String MEMBER_NOT_ENV = "notEnv";
    public static final String MEMBER_CONDITION = "condition";
    public static final String MEMBER_SDK = "sdk";
    public static final String MEMBER_VERSION = "version";
    public static final String MEMBER_MISSING_CLASSES = "missing";
    public static final String MEMBER_RESOURCES = "resources";
    public static final String MEMBER_CONFIGURATION = "configuration";
    public static final String MEMBER_CLASSES = "classes";
    public static final String MEMBER_ENTITIES = "entities";
    public static final String MEMBER_BEANS = "beans";
    public static final String MEMBER_MISSING_BEANS = "missingBeans";
    public static final String MEMBER_OS = "os";
    public static final String MEMBER_NOT_OS = "notOs";
    public static final String MEMBER_BEAN = "bean";
    public static final String MEMBER_BEAN_PROPERTY = "beanProperty";
    private final AnnotationMetadata annotationMetadata;

    public RequiresCondition(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    @Override
    public boolean matches(ConditionContext context) {
        List<AnnotationValue<Requires>> requirements = this.annotationMetadata.getAnnotationValuesByType(Requires.class);
        if (requirements.isEmpty()) {
            return true;
        }
        Object component = context.getComponent();
        boolean isBeanReference = component instanceof BeanDefinitionReference;
        if (isBeanReference) {
            for (AnnotationValue<Requires> requirement : requirements) {
                if (requirement.hasEvaluatedExpressions()) continue;
                this.processPreStartRequirements(context, requirement);
                if (!context.isFailing()) continue;
                return false;
            }
        } else {
            for (AnnotationValue<Requires> requires : requirements) {
                this.processPostStartRequirements(context, requires);
                if (!context.isFailing()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean matchesConfiguration(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_CONFIGURATION)) {
            String configurationName = requirements.stringValue(MEMBER_CONFIGURATION).orElse(null);
            if (StringUtils.isEmpty(configurationName)) {
                return true;
            }
            BeanContext beanContext = context.getBeanContext();
            String minimumVersion = requirements.stringValue(MEMBER_VERSION).orElse(null);
            Optional<BeanConfiguration> beanConfiguration = beanContext.findBeanConfiguration(configurationName);
            if (beanConfiguration.isEmpty()) {
                context.fail("Required configuration [" + configurationName + "] is not active");
                return false;
            }
            String version = beanConfiguration.get().getVersion();
            if (version != null && StringUtils.isNotEmpty(minimumVersion)) {
                boolean result = SemanticVersion.isAtLeast(version, minimumVersion);
                context.fail("Required configuration [" + configurationName + "] version requirements not met. Required: " + minimumVersion + ", Current: " + version);
                return result;
            }
            return true;
        }
        return true;
    }

    private void processPreStartRequirements(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (!this.matchesPresenceOfClasses(context, requirements)) {
            return;
        }
        if (!this.matchesAbsenceOfClasses(context, requirements)) {
            return;
        }
        if (!this.matchesEnvironment(context, requirements)) {
            return;
        }
        if (!this.matchesPresenceOfEntities(context, requirements)) {
            return;
        }
        if (!this.matchesProperty(context, requirements)) {
            return;
        }
        if (!this.matchesMissingProperty(context, requirements)) {
            return;
        }
        if (!this.matchesConfiguration(context, requirements)) {
            return;
        }
        if (!this.matchesSdk(context, requirements)) {
            return;
        }
        if (!this.matchesPresenceOfResources(context, requirements)) {
            return;
        }
        if (!this.matchesCurrentOs(context, requirements)) {
            return;
        }
        this.matchesPresenceOfClasses(context, requirements, MEMBER_BEANS);
    }

    private void processPostStartRequirements(ConditionContext context, AnnotationValue<Requires> requirements) {
        this.processPreStartRequirements(context, requirements);
        if (context.isFailing()) {
            return;
        }
        if (!this.matchesPresenceOfBeans(context, requirements)) {
            return;
        }
        if (!this.matchesAbsenceOfBeans(context, requirements)) {
            return;
        }
        this.matchesCustomConditions(context, requirements);
    }

    private boolean matchesProperty(ConditionContext context, AnnotationValue<Requires> requirements) {
        String property;
        if (requirements.contains(MEMBER_PROPERTY) && StringUtils.isNotEmpty(property = (String)requirements.stringValue(MEMBER_PROPERTY).orElse(null))) {
            String value = requirements.stringValue().orElse(null);
            BeanContext beanContext = context.getBeanContext();
            if (beanContext instanceof PropertyResolver) {
                PropertyResolver propertyResolver = (PropertyResolver)((Object)beanContext);
                String defaultValue = requirements.stringValue(MEMBER_DEFAULT_VALUE).orElse(null);
                if (!propertyResolver.containsProperties(property) && StringUtils.isEmpty(defaultValue)) {
                    boolean hasNotEquals = requirements.contains(MEMBER_NOT_EQUALS);
                    if (hasNotEquals) {
                        return true;
                    }
                    context.fail("Required property [" + property + "] with value [" + value + "] not present");
                    return false;
                }
                if (StringUtils.isNotEmpty(value)) {
                    boolean result;
                    String resolved = this.resolvePropertyValue(property, propertyResolver, defaultValue);
                    boolean bl = result = resolved != null && resolved.equals(value);
                    if (!result) {
                        context.fail("Property [" + property + "] with value [" + resolved + "] does not equal required value: " + value);
                    }
                    return result;
                }
                if (requirements.contains(MEMBER_NOT_EQUALS)) {
                    boolean result;
                    String notEquals = requirements.stringValue(MEMBER_NOT_EQUALS).orElse(null);
                    String resolved = this.resolvePropertyValue(property, propertyResolver, defaultValue);
                    boolean bl = result = resolved == null || !resolved.equals(notEquals);
                    if (!result) {
                        context.fail("Property [" + property + "] with value [" + resolved + "] should not equal: " + notEquals);
                    }
                    return result;
                }
                if (requirements.contains(MEMBER_PATTERN)) {
                    boolean result;
                    String pattern = requirements.stringValue(MEMBER_PATTERN).orElse(null);
                    if (pattern == null) {
                        return true;
                    }
                    String resolved = this.resolvePropertyValue(property, propertyResolver, defaultValue);
                    boolean bl = result = resolved != null && resolved.matches(pattern);
                    if (!result) {
                        context.fail("Property [" + property + "] with value [" + resolved + "] does not match required pattern: " + pattern);
                    }
                    return result;
                }
            } else {
                context.fail("Bean requires property but BeanContext does not support property resolution");
                return false;
            }
        }
        return true;
    }

    private String resolvePropertyValue(String property, PropertyResolver propertyResolver, String defaultValue) {
        return propertyResolver.getProperty(property, ConversionContext.STRING).orElse(defaultValue);
    }

    private boolean matchesMissingProperty(ConditionContext context, AnnotationValue<Requires> requirements) {
        PropertyResolver propertyResolver;
        BeanContext beanContext;
        String property;
        if (requirements.contains(MEMBER_MISSING_PROPERTY) && StringUtils.isNotEmpty(property = (String)requirements.stringValue(MEMBER_MISSING_PROPERTY).orElse(null)) && (beanContext = context.getBeanContext()) instanceof PropertyResolver && (propertyResolver = (PropertyResolver)((Object)beanContext)).containsProperties(property)) {
            context.fail("Property [" + property + "] present");
            return false;
        }
        return true;
    }

    private boolean matchesEnvironment(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_ENV)) {
            BeanContext beanContext;
            Object[] env = requirements.stringValues(MEMBER_ENV);
            if (ArrayUtils.isNotEmpty(env) && (beanContext = context.getBeanContext()) instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)beanContext;
                Environment environment = applicationContext.getEnvironment();
                Set<String> activeNames = environment.getActiveNames();
                boolean result = Arrays.stream(env).anyMatch(activeNames::contains);
                if (!result) {
                    context.fail("None of the required environments [" + ArrayUtils.toString(env) + "] are active: " + activeNames);
                }
                return result;
            }
        } else if (requirements.contains(MEMBER_NOT_ENV)) {
            BeanContext beanContext;
            Object[] env = requirements.stringValues(MEMBER_NOT_ENV);
            if (ArrayUtils.isNotEmpty(env) && (beanContext = context.getBeanContext()) instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)beanContext;
                Environment environment = applicationContext.getEnvironment();
                Set<String> activeNames = environment.getActiveNames();
                boolean result = Arrays.stream(env).noneMatch(activeNames::contains);
                if (!result) {
                    context.fail("Disallowed environments [" + ArrayUtils.toString(env) + "] are active: " + activeNames);
                }
                return result;
            }
            return true;
        }
        return true;
    }

    private boolean matchesCustomConditions(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_CONDITION)) {
            AnnotationClassValue annotationClassValue = requirements.annotationClassValue(MEMBER_CONDITION).orElse(null);
            if (annotationClassValue == null) {
                return true;
            }
            Object instance = annotationClassValue.getInstance().orElse(null);
            if (instance instanceof Condition) {
                Condition condition = (Condition)instance;
                boolean conditionResult = condition.matches(context);
                if (!conditionResult) {
                    context.fail("Custom condition [" + instance.getClass() + "] failed evaluation");
                }
                return conditionResult;
            }
            Class conditionClass = annotationClassValue.getType().orElse(null);
            if (conditionClass == null || conditionClass == TrueCondition.class || !Condition.class.isAssignableFrom(conditionClass)) {
                return true;
            }
            Optional condition = InstantiationUtils.tryInstantiate(conditionClass);
            if (condition.isPresent()) {
                boolean conditionResult = ((Condition)condition.get()).matches(context);
                if (!conditionResult) {
                    context.fail("Custom condition [" + conditionClass + "] failed evaluation");
                }
                return conditionResult;
            }
            Optional<Constructor<Constructor>> constructor = ReflectionUtils.findConstructor(conditionClass, Object.class, Object.class);
            boolean conditionResult = constructor.flatMap(ctor -> InstantiationUtils.tryInstantiate(ctor, null, null)).flatMap(obj -> {
                Object result;
                Optional<Method> method = ReflectionUtils.findMethod(obj.getClass(), "call", ConditionContext.class);
                if (method.isPresent() && (result = ReflectionUtils.invokeMethod(obj, method.get(), context)) instanceof Boolean) {
                    return Optional.of((Boolean)result);
                }
                return Optional.empty();
            }).orElse(false);
            if (!conditionResult) {
                context.fail("Custom condition [" + conditionClass + "] failed evaluation");
            }
            return conditionResult;
        }
        return !context.isFailing();
    }

    private boolean matchesSdk(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_SDK)) {
            Requires.Sdk sdk = requirements.enumValue(MEMBER_SDK, Requires.Sdk.class).orElse(null);
            String version = requirements.stringValue(MEMBER_VERSION).orElse(null);
            if (sdk != null && StringUtils.isNotEmpty(version)) {
                switch (sdk) {
                    case GROOVY: {
                        String groovyVersion = GroovySystem.getVersion();
                        boolean versionMatch = SemanticVersion.isAtLeast(groovyVersion, version);
                        if (!versionMatch) {
                            context.fail("Groovy version [" + groovyVersion + "] must be at least " + version);
                        }
                        return versionMatch;
                    }
                    case KOTLIN: {
                        String kotlinVersion = KotlinVersion.CURRENT.toString();
                        boolean isSupported = SemanticVersion.isAtLeast(kotlinVersion, version);
                        if (!isSupported) {
                            context.fail("Kotlin version [" + kotlinVersion + "] must be at least " + version);
                        }
                        return isSupported;
                    }
                    case JAVA: {
                        String javaVersion = CachedEnvironment.getProperty("java.version");
                        try {
                            boolean result = SemanticVersion.isAtLeast(javaVersion, version);
                            if (!result) {
                                context.fail("Java version [" + javaVersion + "] must be at least " + version);
                            }
                            return result;
                        }
                        catch (Exception e) {
                            if (javaVersion != null) {
                                int requiredVersion;
                                int majorVersion = this.resolveJavaMajorVersion(javaVersion);
                                if (majorVersion >= (requiredVersion = this.resolveJavaMajorVersion(version))) {
                                    return true;
                                }
                                context.fail("Java major version [" + majorVersion + "] must be at least " + requiredVersion);
                            } else {
                                int requiredVersion = this.resolveJavaMajorVersion(version);
                                context.fail("Java major version must be at least " + requiredVersion);
                            }
                            return context.isFailing();
                        }
                    }
                }
                boolean versionCheck = VersionUtils.isAtLeastMicronautVersion(version);
                if (!versionCheck) {
                    context.fail("Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + version);
                }
                return versionCheck;
            }
        }
        return true;
    }

    private int resolveJavaMajorVersion(String javaVersion) {
        int majorVersion = 0;
        if (javaVersion.indexOf(46) > -1) {
            String[] tokens = javaVersion.split("\\.");
            String first = tokens[0];
            if (first.length() == 1) {
                majorVersion = first.charAt(0);
                if (Character.isDigit(majorVersion) && majorVersion == 49 && tokens.length > 1) {
                    majorVersion = tokens[1].charAt(0);
                }
            } else {
                try {
                    majorVersion = Integer.parseInt(first);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (javaVersion.length() == 1) {
            char ch = javaVersion.charAt(0);
            if (Character.isDigit(ch)) {
                majorVersion = ch;
            }
        } else {
            try {
                majorVersion = Integer.parseInt(javaVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return majorVersion;
    }

    private boolean matchesPresenceOfClasses(ConditionContext context, AnnotationValue<Requires> convertibleValues) {
        return this.matchesPresenceOfClasses(context, convertibleValues, MEMBER_CLASSES);
    }

    private boolean matchesAbsenceOfClasses(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_MISSING_CLASSES)) {
            Object[] classValues = requirements.annotationClassValues(MEMBER_MISSING_CLASSES);
            if (ArrayUtils.isNotEmpty(classValues)) {
                for (Object classValue : classValues) {
                    if (!((AnnotationClassValue)classValue).getType().isPresent()) continue;
                    context.fail("Class [" + ((AnnotationClassValue)classValue).getName() + "] is not absent");
                    return false;
                }
            } else {
                return this.matchAbsenceOfClassNames(context, requirements);
            }
        }
        return true;
    }

    private boolean matchAbsenceOfClassNames(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_MISSING_CLASSES)) {
            String[] classNameArray = requirements.stringValues(MEMBER_MISSING_CLASSES);
            ClassLoader classLoader = context.getBeanContext().getClassLoader();
            for (String name : classNameArray) {
                if (!ClassUtils.isPresent(name, classLoader)) continue;
                context.fail("Class [" + name + "] is not absent");
                return false;
            }
        }
        return true;
    }

    private boolean matchesPresenceOfClasses(ConditionContext context, AnnotationValue<Requires> requirements, String attr) {
        if (requirements.contains(attr)) {
            AnnotationClassValue<?>[] classValues;
            for (AnnotationClassValue<?> classValue : classValues = requirements.annotationClassValues(attr)) {
                if (!classValue.getType().isEmpty()) continue;
                context.fail("Class [" + classValue.getName() + "] is not present");
                return false;
            }
        }
        return true;
    }

    private boolean matchesPresenceOfEntities(ConditionContext context, AnnotationValue<Requires> annotationValue) {
        BeanContext beanContext;
        Object[] classNames;
        if (annotationValue.contains(MEMBER_ENTITIES) && ArrayUtils.isNotEmpty(classNames = annotationValue.annotationClassValues(MEMBER_ENTITIES)) && (beanContext = context.getBeanContext()) instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            for (Object classValue : classNames) {
                Class annotationType;
                Optional entityType = ((AnnotationClassValue)classValue).getType();
                if (entityType.isEmpty()) {
                    context.fail("Annotation type [" + ((AnnotationClassValue)classValue).getName() + "] not present on classpath");
                    return false;
                }
                Environment environment = applicationContext.getEnvironment();
                if (!environment.scan(annotationType = entityType.get()).findFirst().isEmpty()) continue;
                context.fail("No entities found in packages [" + String.join((CharSequence)", ", environment.getPackages()) + "] for annotation: " + annotationType);
                return false;
            }
        }
        return true;
    }

    private boolean matchesPresenceOfBeans(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_BEANS) || requirements.contains(MEMBER_BEAN)) {
            Class memberBean;
            Object[] beans = requirements.classValues(MEMBER_BEANS);
            if (requirements.contains(MEMBER_BEAN) && (memberBean = (Class)requirements.classValue(MEMBER_BEAN).orElse(null)) != null) {
                beans = ArrayUtils.concat(beans, memberBean);
            }
            if (ArrayUtils.isNotEmpty(beans)) {
                BeanContext beanContext = context.getBeanContext();
                for (Object type : beans) {
                    if (beanContext.containsBean((Class<?>)type)) continue;
                    context.fail("No bean of type [" + (Class)type + "] present within context");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean matchesAbsenceOfBeans(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_MISSING_BEANS)) {
            Object[] missingBeans = requirements.classValues(MEMBER_MISSING_BEANS);
            Object component = context.getComponent();
            if (ArrayUtils.isNotEmpty(missingBeans) && component instanceof BeanDefinition) {
                BeanDefinition bd = (BeanDefinition)component;
                DefaultBeanContext beanContext = (DefaultBeanContext)context.getBeanContext();
                for (Object type : missingBeans) {
                    Collection beanDefinitions = beanContext.findBeanCandidates(context.getBeanResolutionContext(), Argument.of(type), bd);
                    for (BeanDefinition beanDefinition : beanDefinitions) {
                        if (beanDefinition.isAbstract()) continue;
                        context.fail("Existing bean [" + beanDefinition.getName() + "] of type [" + (Class)type + "] registered in context");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean matchesPresenceOfResources(ConditionContext context, AnnotationValue<Requires> requirements) {
        Object[] resourcePaths;
        if (requirements.contains(MEMBER_RESOURCES) && ArrayUtils.isNotEmpty(resourcePaths = requirements.stringValues(MEMBER_RESOURCES))) {
            List<ResourceLoader> resourceLoaders;
            BeanContext beanContext = context.getBeanContext();
            if (beanContext instanceof ApplicationContext) {
                Environment resourceLoader = ((ApplicationContext)beanContext).getEnvironment();
                resourceLoaders = Arrays.asList(resourceLoader, FileSystemResourceLoader.defaultLoader());
            } else {
                resourceLoaders = Arrays.asList(ClassPathResourceLoader.defaultLoader(beanContext.getClassLoader()), FileSystemResourceLoader.defaultLoader());
            }
            ResourceResolver resolver = new ResourceResolver(resourceLoaders);
            for (Object resourcePath : resourcePaths) {
                if (!resolver.getResource((String)resourcePath).isEmpty()) continue;
                context.fail("Resource [" + (String)resourcePath + "] does not exist");
                return false;
            }
        }
        return true;
    }

    private boolean matchesCurrentOs(ConditionContext context, AnnotationValue<Requires> requirements) {
        if (requirements.contains(MEMBER_OS)) {
            Requires.Family currentOs;
            EnumSet<Requires.Family> os = requirements.enumValuesSet(MEMBER_OS, Requires.Family.class);
            if (!os.contains((Object)(currentOs = OperatingSystem.getCurrent().getFamily()))) {
                context.fail("The current operating system [" + currentOs.name() + "] is not one of the required systems [" + os + "]");
                return false;
            }
        } else if (requirements.contains(MEMBER_NOT_OS)) {
            Requires.Family currentOs = OperatingSystem.getCurrent().getFamily();
            EnumSet<Requires.Family> notOs = requirements.enumValuesSet(MEMBER_NOT_OS, Requires.Family.class);
            if (notOs.contains((Object)currentOs)) {
                context.fail("The current operating system [" + currentOs.name() + "] is one of the disallowed systems [" + notOs + "]");
                return false;
            }
        }
        return true;
    }
}

