/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpRequestWrapper;
import io.micronaut.http.PushCapableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.bind.binders.CookieAnnotationBinder;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.DefaultUnmatchedRequestArgumentBinder;
import io.micronaut.http.bind.binders.HeaderAnnotationBinder;
import io.micronaut.http.bind.binders.PartAnnotationBinder;
import io.micronaut.http.bind.binders.PathVariableAnnotationBinder;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.bind.binders.QueryValueArgumentBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestAttributeAnnotationBinder;
import io.micronaut.http.bind.binders.RequestBeanAnnotationBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class DefaultRequestBinderRegistry
implements RequestBinderRegistry {
    private static final long CACHE_MAX_SIZE = 30L;
    private final Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation = new LinkedHashMap<Class<? extends Annotation>, RequestArgumentBinder>();
    private final Map<TypeAndAnnotation, RequestArgumentBinder> byTypeAndAnnotation = new LinkedHashMap<TypeAndAnnotation, RequestArgumentBinder>();
    private final Map<Integer, RequestArgumentBinder> byType = new LinkedHashMap<Integer, RequestArgumentBinder>();
    private final ConversionService conversionService;
    private final Map<TypeAndAnnotation, Optional<RequestArgumentBinder>> argumentBinderCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final List<RequestArgumentBinder<Object>> unmatchedBinders = new ArrayList<RequestArgumentBinder<Object>>();
    private final DefaultUnmatchedRequestArgumentBinder defaultUnmatchedRequestArgumentBinder;

    public DefaultRequestBinderRegistry(ConversionService conversionService, RequestArgumentBinder ... binders) {
        this(conversionService, Arrays.asList(binders));
    }

    public DefaultRequestBinderRegistry(ConversionService conversionService, List<RequestArgumentBinder> binders) {
        this(conversionService, binders, new DefaultBodyAnnotationBinder(conversionService));
    }

    @Inject
    public DefaultRequestBinderRegistry(ConversionService conversionService, List<RequestArgumentBinder> binders, DefaultBodyAnnotationBinder bodyAnnotationBinder) {
        this.conversionService = conversionService;
        if (CollectionUtils.isNotEmpty(binders)) {
            for (RequestArgumentBinder binder : binders) {
                this.addArgumentBinder(binder);
            }
        }
        this.byAnnotation.put(Body.class, bodyAnnotationBinder);
        this.registerDefaultAnnotationBinders(this.byAnnotation);
        this.byType.put(Argument.of(HttpHeaders.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getHeaders()));
        this.byType.put(Argument.of(HttpRequest.class).typeHashCode(), (argument, source) -> DefaultRequestBinderRegistry.convertBodyIfNecessary(bodyAnnotationBinder, argument, source, false));
        this.byType.put(Argument.of(PushCapableHttpRequest.class).typeHashCode(), (argument, source) -> {
            if (source instanceof PushCapableHttpRequest) {
                return DefaultRequestBinderRegistry.convertBodyIfNecessary(bodyAnnotationBinder, argument, source, true);
            }
            return ArgumentBinder.BindingResult.unsatisfied();
        });
        this.byType.put(Argument.of(HttpParameters.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getParameters()));
        this.byType.put(Argument.of(Cookies.class).typeHashCode(), (argument, source) -> () -> Optional.of(source.getCookies()));
        this.byType.put(Argument.of(Cookie.class).typeHashCode(), (context, source) -> {
            String name;
            Cookies cookies = source.getCookies();
            Cookie cookie = cookies.get(name = context.getArgument().getName());
            if (cookie == null) {
                cookie = cookies.get(NameUtils.hyphenate(name));
            }
            Cookie finalCookie = cookie;
            return () -> finalCookie != null ? Optional.of(finalCookie) : Optional.empty();
        });
        this.defaultUnmatchedRequestArgumentBinder = new DefaultUnmatchedRequestArgumentBinder(List.of(new QueryValueArgumentBinder(conversionService), new RequestAttributeAnnotationBinder(conversionService)), this.unmatchedBinders, List.of(bodyAnnotationBinder));
    }

    @Override
    public <T> void addArgumentBinder(ArgumentBinder<T, HttpRequest<?>> binder) {
        if (binder instanceof AnnotatedRequestArgumentBinder) {
            AnnotatedRequestArgumentBinder annotatedRequestArgumentBinder = (AnnotatedRequestArgumentBinder)binder;
            Class annotationType = annotatedRequestArgumentBinder.getAnnotationType();
            if (binder instanceof TypedRequestArgumentBinder) {
                TypedRequestArgumentBinder typedRequestArgumentBinder = (TypedRequestArgumentBinder)binder;
                Argument argumentType = typedRequestArgumentBinder.argumentType();
                this.byTypeAndAnnotation.put(new TypeAndAnnotation(argumentType, annotationType), (RequestArgumentBinder)binder);
                List<Class<?>> superTypes = typedRequestArgumentBinder.superTypes();
                if (CollectionUtils.isNotEmpty(superTypes)) {
                    for (Class<?> superType : superTypes) {
                        this.byTypeAndAnnotation.put(new TypeAndAnnotation(Argument.of(superType), annotationType), (RequestArgumentBinder)binder);
                    }
                }
            } else {
                this.byAnnotation.put(annotationType, annotatedRequestArgumentBinder);
            }
        } else if (binder instanceof TypedRequestArgumentBinder) {
            TypedRequestArgumentBinder typedRequestArgumentBinder = (TypedRequestArgumentBinder)binder;
            this.byType.put(typedRequestArgumentBinder.argumentType().typeHashCode(), typedRequestArgumentBinder);
        }
    }

    @Override
    public void addUnmatchedRequestArgumentBinder(RequestArgumentBinder<Object> binder) {
        this.unmatchedBinders.add(binder);
    }

    @Override
    public <T> Optional<ArgumentBinder<T, HttpRequest<?>>> findArgumentBinder(Argument<T> argument) {
        Optional<Class<? extends Annotation>> opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent()) {
            Class<? extends Annotation> annotationType = opt.get();
            RequestArgumentBinder binder = this.findBinder(argument, annotationType);
            if (binder == null) {
                binder = this.byAnnotation.get(annotationType);
            }
            if (binder != null) {
                return Optional.of(binder);
            }
        } else {
            RequestArgumentBinder binder = this.byType.get(argument.typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
            binder = this.byType.get(Argument.of(argument.getType()).typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
        }
        return Optional.of(this.defaultUnmatchedRequestArgumentBinder);
    }

    protected <T> RequestArgumentBinder findBinder(Argument<T> argument, Class<? extends Annotation> annotationType) {
        TypeAndAnnotation key = new TypeAndAnnotation(argument, annotationType);
        return this.argumentBinderCache.computeIfAbsent(key, key1 -> {
            RequestArgumentBinder requestArgumentBinder = this.byTypeAndAnnotation.get(key1);
            if (requestArgumentBinder == null) {
                Class javaType = key1.type.getType();
                for (Map.Entry<TypeAndAnnotation, RequestArgumentBinder> entry : this.byTypeAndAnnotation.entrySet()) {
                    Argument<?> t;
                    TypeAndAnnotation typeAndAnnotation = entry.getKey();
                    if (typeAndAnnotation.annotation != annotationType || !(t = typeAndAnnotation.type).getType().isAssignableFrom(javaType) || (requestArgumentBinder = entry.getValue()) == null) continue;
                    break;
                }
                if (requestArgumentBinder == null) {
                    requestArgumentBinder = this.byTypeAndAnnotation.get(new TypeAndAnnotation(Argument.of(argument.getType()), annotationType));
                }
            }
            return Optional.ofNullable(requestArgumentBinder);
        }).orElse(null);
    }

    protected void registerDefaultAnnotationBinders(Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation) {
        CookieAnnotationBinder cookieAnnotationBinder = new CookieAnnotationBinder(this.conversionService);
        byAnnotation.put(cookieAnnotationBinder.getAnnotationType(), cookieAnnotationBinder);
        HeaderAnnotationBinder headerAnnotationBinder = new HeaderAnnotationBinder(this.conversionService);
        byAnnotation.put(headerAnnotationBinder.getAnnotationType(), headerAnnotationBinder);
        QueryValueArgumentBinder queryValueAnnotationBinder = new QueryValueArgumentBinder(this.conversionService);
        byAnnotation.put(queryValueAnnotationBinder.getAnnotationType(), queryValueAnnotationBinder);
        RequestAttributeAnnotationBinder requestAttributeAnnotationBinder = new RequestAttributeAnnotationBinder(this.conversionService);
        byAnnotation.put(requestAttributeAnnotationBinder.getAnnotationType(), requestAttributeAnnotationBinder);
        PathVariableAnnotationBinder pathVariableAnnotationBinder = new PathVariableAnnotationBinder(this.conversionService);
        byAnnotation.put(pathVariableAnnotationBinder.getAnnotationType(), pathVariableAnnotationBinder);
        RequestBeanAnnotationBinder requestBeanAnnotationBinder = new RequestBeanAnnotationBinder(this);
        byAnnotation.put(requestBeanAnnotationBinder.getAnnotationType(), requestBeanAnnotationBinder);
        PartAnnotationBinder partAnnotationBinder = new PartAnnotationBinder();
        byAnnotation.put(partAnnotationBinder.getAnnotationType(), partAnnotationBinder);
        if (KotlinUtils.KOTLIN_COROUTINES_SUPPORTED) {
            ContinuationArgumentBinder continuationArgumentBinder = new ContinuationArgumentBinder();
            this.byType.put(continuationArgumentBinder.argumentType().typeHashCode(), continuationArgumentBinder);
        }
    }

    private static ArgumentBinder.BindingResult<? extends HttpRequest<?>> convertBodyIfNecessary(DefaultBodyAnnotationBinder<Object> bodyAnnotationBinder, ArgumentConversionContext<? extends HttpRequest<?>> context, final HttpRequest<?> source, final boolean pushCapable) {
        Optional<Argument> typeVariable;
        if (source.getMethod().permitsRequestBody() && (typeVariable = context.getFirstTypeVariable().filter(arg -> arg.getType() != Object.class).filter(arg -> arg.getType() != Void.class)).isPresent()) {
            ArgumentConversionContext unwrappedConversionContext = ConversionContext.of(typeVariable.get());
            final ArgumentBinder.BindingResult<Object> bodyBound = bodyAnnotationBinder.bindFullBody(unwrappedConversionContext, source);
            return new PendingRequestBindingResult<HttpRequest<?>>(){

                @Override
                public boolean isPending() {
                    PendingRequestBindingResult p;
                    return bodyBound instanceof PendingRequestBindingResult && (p = (PendingRequestBindingResult)bodyBound).isPending();
                }

                @Override
                public List<ConversionError> getConversionErrors() {
                    return bodyBound.getConversionErrors();
                }

                @Override
                public Optional<HttpRequest<?>> getValue() {
                    final Optional body = bodyBound.getValue();
                    if (pushCapable) {
                        return Optional.of(new PushCapableRequestWrapper<Object>(source, (PushCapableHttpRequest)source){

                            @Override
                            public Optional<Object> getBody() {
                                return body;
                            }
                        });
                    }
                    return Optional.of(new HttpRequestWrapper<Object>(source){

                        @Override
                        public Optional<Object> getBody() {
                            return body;
                        }
                    });
                }
            };
        }
        return () -> Optional.of(source);
    }

    private static final class TypeAndAnnotation {
        private final Argument<?> type;
        private final Class<? extends Annotation> annotation;

        public TypeAndAnnotation(Argument<?> type, Class<? extends Annotation> annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndAnnotation that = (TypeAndAnnotation)o;
            if (!this.type.equalsType(that.type)) {
                return false;
            }
            return this.annotation.equals(that.annotation);
        }

        public int hashCode() {
            int result = this.type.typeHashCode();
            result = 31 * result + this.annotation.hashCode();
            return result;
        }
    }

    private static class PushCapableRequestWrapper<B>
    extends HttpRequestWrapper<B>
    implements PushCapableHttpRequest<B> {
        private final PushCapableHttpRequest<?> push;

        public PushCapableRequestWrapper(HttpRequest<B> primary, PushCapableHttpRequest<?> push) {
            super(primary);
            this.push = push;
        }

        @Override
        public boolean isServerPushSupported() {
            return this.push.isServerPushSupported();
        }

        @Override
        public PushCapableHttpRequest<B> serverPush(@NonNull HttpRequest<?> request) {
            this.push.serverPush(request);
            return this;
        }
    }
}

