/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
@Internal
@BootstrapContextCompatible
@Requires(property="micronaut.http.legacy-text-conversion", value="true")
final class ConversionTextPlainHandler<T>
implements MessageBodyHandler<T> {
    private final ApplicationConfiguration configuration;
    private final ConversionService conversionService;

    ConversionTextPlainHandler(ApplicationConfiguration configuration, ConversionService conversionService) {
        this.configuration = configuration;
        this.conversionService = conversionService;
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        String text;
        try {
            text = new String(inputStream.readAllBytes(), this.configuration.getDefaultCharset());
        }
        catch (IOException e) {
            throw new CodecException("Error reading body text: " + e.getMessage(), e);
        }
        return this.convert(type, text);
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        T r = this.convert(type, byteBuffer.toString(this.configuration.getDefaultCharset()));
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)((Object)byteBuffer);
            rc.release();
        }
        return r;
    }

    private T convert(Argument<T> type, String text) {
        return this.conversionService.convert((Object)text, type).orElseThrow(() -> new CodecException("Cannot decode message with value [" + text + "] to type: " + type));
    }

    @Override
    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        if (!outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.set("Content-Type", mediaType);
        }
        try {
            outputStream.write(object.toString().getBytes(MessageBodyWriter.getCharset(outgoingHeaders)));
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }
}

