/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.netty.body.JsonCounter;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.convert.LazyJsonNode;
import io.micronaut.json.tree.JsonNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;

@Internal
public final class JsonContentProcessor
extends AbstractHttpContentProcessor {
    private final JsonMapper jsonMapper;
    private final JsonCounter counter = new JsonCounter();
    private boolean tokenize;
    private ByteBuf singleBuffer;
    private CompositeByteBuf compositeBuffer;

    public JsonContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration, JsonMapper jsonMapper) {
        super(nettyHttpRequest, configuration);
        this.jsonMapper = jsonMapper;
        boolean bl = this.tokenize = !this.hasContentType(MediaType.APPLICATION_JSON_TYPE);
        if (!this.tokenize) {
            this.counter.noTokenization();
        }
    }

    @Override
    public HttpContentProcessor resultType(Argument<?> type) {
        Optional<Argument<?>> genericArgument;
        Class targetType;
        boolean isJsonStream = this.hasContentType(MediaType.APPLICATION_JSON_STREAM_TYPE);
        if (type != null && Publishers.isConvertibleToPublisher(targetType = type.getType()) && !Publishers.isSingle(targetType) && (genericArgument = type.getFirstTypeVariable()).isPresent() && !Iterable.class.isAssignableFrom(genericArgument.get().getType()) && !isJsonStream) {
            this.counter.unwrapTopLevelArray();
            this.tokenize = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processSingle(ByteBuf data) throws Throwable {
        if (this.tokenize || !data.isReadable()) {
            return null;
        }
        if ((long)data.readableBytes() > this.requestMaxSize) {
            this.fireExceedsLength(data.readableBytes(), this.requestMaxSize, new DefaultHttpContent(data));
        }
        int start = data.readerIndex();
        this.counter.feed(data);
        data.readerIndex(start);
        ByteBuffer<ByteBuf> wrapped = NettyByteBufferFactory.DEFAULT.wrap(data);
        if (((NettyHttpServerConfiguration)this.configuration).isEagerParsing()) {
            try {
                JsonNode jsonNode = this.jsonMapper.readValue(wrapped, Argument.of(JsonNode.class));
                return jsonNode;
            }
            finally {
                data.release();
            }
        }
        return new LazyJsonNode(wrapped);
    }

    private boolean hasContentType(MediaType expected) {
        Optional<MediaType> actual = this.nettyHttpRequest.getContentType();
        return actual.isPresent() && actual.get().equals(expected);
    }

    @Override
    protected void onData(ByteBufHolder message, Collection<Object> out) throws Throwable {
        ByteBuf content = message.content();
        try {
            this.countLoop(out, content);
        }
        catch (Exception e) {
            this.releaseBuffers();
            throw e;
        }
        finally {
            content.release();
        }
    }

    private void releaseBuffers() {
        if (this.singleBuffer != null) {
            this.singleBuffer.release();
            this.singleBuffer = null;
        }
        if (this.compositeBuffer != null) {
            this.compositeBuffer.release();
            this.compositeBuffer = null;
        }
    }

    private void countLoop(Collection<Object> out, ByteBuf content) throws IOException {
        long initialPosition = this.counter.position();
        long bias = initialPosition - (long)content.readerIndex();
        while (content.isReadable()) {
            this.counter.feed(content);
            JsonCounter.BufferRegion bufferRegion = this.counter.pollFlushedRegion();
            if (bufferRegion == null) continue;
            long start = Math.max(initialPosition, bufferRegion.start());
            this.buffer(content.retainedSlice(Math.toIntExact(start - bias), Math.toIntExact(bufferRegion.end() - start)));
            this.flush(out);
        }
        if (this.counter.isBuffering()) {
            int currentBufferStart = Math.toIntExact(Math.max(initialPosition, this.counter.bufferStart()) - bias);
            content.readerIndex(currentBufferStart);
            this.buffer(content.retain());
        }
    }

    private void buffer(ByteBuf buffer) {
        if (this.singleBuffer == null && this.compositeBuffer == null) {
            this.singleBuffer = buffer;
        } else {
            if (this.compositeBuffer == null) {
                this.compositeBuffer = buffer.alloc().compositeBuffer(((NettyHttpServerConfiguration)this.configuration).getJsonBufferMaxComponents());
                this.compositeBuffer.addComponent(true, this.singleBuffer);
                this.singleBuffer = null;
            }
            this.compositeBuffer.addComponent(true, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(Collection<Object> out) throws IOException {
        ByteBuf completedNode = this.compositeBuffer == null ? this.singleBuffer : this.compositeBuffer;
        ByteBuffer<ByteBuf> wrapped = NettyByteBufferFactory.DEFAULT.wrap(completedNode);
        if (((NettyHttpServerConfiguration)this.configuration).isEagerParsing()) {
            try {
                out.add(this.jsonMapper.readValue(wrapped, Argument.of(JsonNode.class)));
            }
            finally {
                this.releaseBuffers();
            }
        } else {
            out.add(new LazyJsonNode(wrapped));
            this.compositeBuffer = null;
            this.singleBuffer = null;
        }
    }

    @Override
    public void complete(Collection<Object> out) throws Throwable {
        if (this.singleBuffer != null || this.compositeBuffer != null) {
            this.flush(out);
        }
    }
}

