/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.core.tree;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;

final class JsonNodeTraversingParser
extends ParserMinimalBase {
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private boolean first = true;
    private ObjectCodec codec = null;

    JsonNodeTraversingParser(JsonNode node) {
        Context root = node.isArray() ? new ArrayContext(null, node.values().iterator()) : (node.isObject() ? new ObjectContext(null, node.entries().iterator()) : new SingleContext(node));
        this.contextStack.add(root);
    }

    private JsonNode currentNodeOrNull() {
        for (Context context : this.contextStack) {
            JsonNode node = context.currentNode();
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        Context context;
        if (this.first) {
            this.first = false;
            assert (!this.contextStack.isEmpty());
            this._currToken = this.contextStack.peekFirst().currentToken();
            return this._currToken;
        }
        while (true) {
            if (this.contextStack.isEmpty()) {
                return null;
            }
            context = this.contextStack.peekFirst();
            if (!context.lastToken) break;
            this.contextStack.removeFirst();
        }
        Context childContext = context.next();
        if (childContext != null) {
            this.contextStack.addFirst(childContext);
            this._currToken = childContext.currentToken();
        } else {
            this._currToken = context.currentToken();
        }
        return this._currToken;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }

    @Override
    public String getCurrentName() throws IOException {
        return this.contextStack.isEmpty() ? null : this.contextStack.peekFirst().getCurrentName();
    }

    @Override
    public ObjectCodec getCodec() {
        return this.codec;
    }

    @Override
    public void setCodec(ObjectCodec oc) {
        this.codec = oc;
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void close() throws IOException {
        this.contextStack.clear();
    }

    @Override
    public boolean isClosed() {
        return this.contextStack.isEmpty();
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this.contextStack.peekFirst();
    }

    @Override
    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public void overrideCurrentName(String name) {
        if (!this.contextStack.isEmpty()) {
            this.contextStack.peekFirst().setCurrentName(name);
        }
    }

    @Override
    public String getText() throws IOException {
        if (this.contextStack.isEmpty()) {
            return null;
        }
        return this.contextStack.peekFirst().getText();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        String text = this.getText();
        if (text != null) {
            return text.toCharArray();
        }
        return new char[0];
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    private JsonNode currentNumberNode() throws JsonParseException {
        JsonNode node = this.currentNodeOrNull();
        if (node != null && node.isNumber()) {
            return node;
        }
        throw new JsonParseException(this, "Not a number");
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this.currentNumberNode().getNumberValue();
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        JsonNode currentNode = this.currentNodeOrNull();
        if (currentNode == null || !currentNode.isNumber()) {
            return null;
        }
        Number value = currentNode.getNumberValue();
        if (value instanceof BigDecimal) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if (value instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (value instanceof Float) {
            return JsonParser.NumberType.FLOAT;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return JsonParser.NumberType.INT;
        }
        if (value instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        if (value instanceof BigInteger) {
            return JsonParser.NumberType.BIG_INTEGER;
        }
        throw new IllegalStateException("Unknown number type " + value.getClass().getName());
    }

    @Override
    public int getIntValue() throws IOException {
        return this.currentNumberNode().getIntValue();
    }

    @Override
    public long getLongValue() throws IOException {
        return this.currentNumberNode().getLongValue();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentNumberNode().getBigIntegerValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return this.currentNumberNode().getFloatValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.currentNumberNode().getDoubleValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.currentNumberNode().getBigDecimalValue();
    }

    @Override
    public int getTextLength() throws IOException {
        String text = this.getText();
        return text != null ? text.length() : 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        JsonNode currentNode = this.currentNodeOrNull();
        if (currentNode != null && currentNode.isNull()) {
            return null;
        }
        String text = this.getText();
        if (text != null) {
            return b64variant.decode(text);
        }
        return null;
    }

    private static String nodeToText(JsonNode node) {
        if (node.isString()) {
            return node.getStringValue();
        }
        if (node.isBoolean()) {
            return Boolean.toString(node.getBooleanValue());
        }
        if (node.isNumber()) {
            return node.getNumberValue().toString();
        }
        if (node.isNull()) {
            return "null";
        }
        if (node.isArray()) {
            return "[";
        }
        return "{";
    }

    private static JsonToken asToken(JsonNode node) {
        if (node.isString()) {
            return JsonToken.VALUE_STRING;
        }
        if (node.isBoolean()) {
            return node.getBooleanValue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }
        if (node.isNumber()) {
            Number numberValue = node.getNumberValue();
            return numberValue instanceof Float || numberValue instanceof Double || numberValue instanceof BigDecimal ? JsonToken.VALUE_NUMBER_FLOAT : JsonToken.VALUE_NUMBER_INT;
        }
        if (node.isNull()) {
            return JsonToken.VALUE_NULL;
        }
        if (node.isArray()) {
            return JsonToken.START_ARRAY;
        }
        return JsonToken.START_OBJECT;
    }

    private static class ArrayContext
    extends Context {
        final Iterator<JsonNode> iterator;
        JsonNode currentNode = null;

        ArrayContext(Context parent, Iterator<JsonNode> iterator) {
            super(parent);
            this._type = 1;
            this.iterator = iterator;
        }

        @Override
        @Nullable
        Context next() {
            if (this.iterator.hasNext()) {
                this.currentNode = this.iterator.next();
                return this.createSubContextIfContainer(this.currentNode);
            }
            this.currentNode = null;
            this.lastToken = true;
            return null;
        }

        @Override
        JsonNode currentNode() {
            return this.currentNode;
        }

        @Override
        public String getCurrentName() {
            return null;
        }

        @Override
        void setCurrentName(String currentName) {
        }

        @Override
        JsonToken currentToken() {
            if (this.currentNode == null) {
                return this.lastToken ? JsonToken.END_ARRAY : JsonToken.START_ARRAY;
            }
            return JsonNodeTraversingParser.asToken(this.currentNode);
        }

        @Override
        String getText() {
            if (this.currentNode != null) {
                return JsonNodeTraversingParser.nodeToText(this.currentNode);
            }
            return this.currentToken().asString();
        }
    }

    private static abstract class Context
    extends JsonStreamContext {
        boolean lastToken = false;
        private final Context parent;

        Context(Context parent) {
            this.parent = parent;
        }

        protected Context createSubContextIfContainer(JsonNode node) {
            if (node.isArray()) {
                return new ArrayContext(this, node.values().iterator());
            }
            if (node.isObject()) {
                return new ObjectContext(this, node.entries().iterator());
            }
            return null;
        }

        @Override
        public final Context getParent() {
            return this.parent;
        }

        @Nullable
        abstract Context next();

        @Nullable
        abstract JsonNode currentNode();

        @Override
        public abstract String getCurrentName();

        abstract void setCurrentName(String var1);

        abstract JsonToken currentToken();

        abstract String getText();
    }

    private static class ObjectContext
    extends Context {
        final Iterator<Map.Entry<String, JsonNode>> iterator;
        @Nullable
        String currentName = null;
        @Nullable
        JsonNode currentValue = null;
        boolean inFieldName = false;

        ObjectContext(Context parent, Iterator<Map.Entry<String, JsonNode>> iterator) {
            super(parent);
            this._type = 2;
            this.iterator = iterator;
        }

        @Override
        @Nullable
        Context next() {
            if (this.inFieldName) {
                this.inFieldName = false;
                assert (this.currentValue != null);
                return this.createSubContextIfContainer(this.currentValue);
            }
            if (this.iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = this.iterator.next();
                this.currentName = entry.getKey();
                this.currentValue = entry.getValue();
                this.inFieldName = true;
            } else {
                this.lastToken = true;
                this.currentName = null;
                this.currentValue = null;
            }
            return null;
        }

        @Override
        @Nullable
        JsonNode currentNode() {
            return this.inFieldName ? null : this.currentValue;
        }

        @Override
        @Nullable
        public String getCurrentName() {
            return this.currentName;
        }

        @Override
        void setCurrentName(@Nullable String currentName) {
            this.currentName = currentName;
        }

        @Override
        JsonToken currentToken() {
            if (this.inFieldName) {
                return JsonToken.FIELD_NAME;
            }
            if (this.currentValue != null) {
                return JsonNodeTraversingParser.asToken(this.currentValue);
            }
            if (this.lastToken) {
                return JsonToken.END_OBJECT;
            }
            return JsonToken.START_OBJECT;
        }

        @Override
        String getText() {
            if (this.inFieldName) {
                return this.currentName;
            }
            if (this.currentValue != null) {
                return JsonNodeTraversingParser.nodeToText(this.currentValue);
            }
            return this.currentToken().asString();
        }
    }

    private static class SingleContext
    extends Context {
        private final JsonNode value;

        SingleContext(JsonNode value) {
            super(null);
            this._type = 0;
            this.value = value;
            this.lastToken = true;
        }

        @Override
        @Nullable
        Context next() {
            return null;
        }

        @Override
        @Nullable
        JsonNode currentNode() {
            return this.value;
        }

        @Override
        public String getCurrentName() {
            return null;
        }

        @Override
        void setCurrentName(String currentName) {
        }

        @Override
        JsonToken currentToken() {
            return JsonNodeTraversingParser.asToken(this.value);
        }

        @Override
        String getText() {
            return JsonNodeTraversingParser.nodeToText(this.value);
        }
    }
}

