/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.health.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.health.HealthStatus;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthResult;

@ServerFilter(value={"${endpoints.all.path:/}${endpoints.health.id:health}", "${endpoints.all.path:/}${endpoints.health.id:health}/liveness", "${endpoints.all.path:/}${endpoints.health.id:health}/readiness"})
@Requires(beans={HealthEndpoint.class})
@Internal
public class HealthResultFilter {
    public static final String DEFAULT_MAPPING = "${endpoints.all.path:/}${endpoints.health.id:health}";
    public static final String LIVENESS_PROBE_MAPPING = "${endpoints.all.path:/}${endpoints.health.id:health}/liveness";
    public static final String READINESS_PROBE_MAPPING = "${endpoints.all.path:/}${endpoints.health.id:health}/readiness";
    private final HealthEndpoint healthEndpoint;

    protected HealthResultFilter(HealthEndpoint healthEndpoint) {
        this.healthEndpoint = healthEndpoint;
    }

    @ResponseFilter
    public void doFilter(MutableHttpResponse<?> response) {
        Object body = response.body();
        if (body instanceof HealthResult) {
            HealthResult healthResult = (HealthResult)body;
            HealthStatus status = healthResult.getStatus();
            HttpStatus httpStatus = this.healthEndpoint.getStatusConfiguration().getHttpMapping().get(status.getName());
            if (httpStatus != null) {
                response.status(httpStatus);
            } else {
                boolean operational = status.getOperational().orElse(true);
                if (!operational) {
                    response.status(HttpStatus.SERVICE_UNAVAILABLE);
                }
            }
        }
    }
}

