/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.core.exceptions.BeanExceptionHandler;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.scheduling.DefaultTaskExceptionHandler;

public interface TaskExceptionHandler<T, E extends Throwable>
extends BeanExceptionHandler<T, E> {
    default public void handleCreationFailure(BeanDefinition<T> beanType, E throwable) {
        if (DefaultTaskExceptionHandler.LOG.isErrorEnabled()) {
            StringBuilder message = new StringBuilder("Error creating scheduled task ");
            if (beanType != null) {
                message.append("for bean [").append(beanType.asArgument()).append("] ");
            }
            message.append(((Throwable)throwable).getMessage());
            DefaultTaskExceptionHandler.LOG.error(message.toString(), (Throwable)throwable);
        }
    }
}

