/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.NamingStrategyLocator;
import io.micronaut.serde.SerializerLocator;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReferenceManager;
import io.micronaut.serde.reference.SerializationReference;
import java.io.IOException;

@Indexed(value=Serializer.class)
public interface Serializer<T> {
    @NonNull
    default public Serializer<T> createSpecific(@NonNull EncoderContext context, @NonNull Argument<? extends T> type) throws SerdeException {
        return this;
    }

    public void serialize(@NonNull Encoder var1, @NonNull EncoderContext var2, @NonNull Argument<? extends T> var3, @NonNull T var4) throws IOException;

    default public boolean isEmpty(@NonNull EncoderContext context, @Nullable T value) {
        return value == null;
    }

    default public boolean isAbsent(@NonNull EncoderContext context, @Nullable T value) {
        return value == null;
    }

    public static interface EncoderContext
    extends SerializerLocator,
    PropertyReferenceManager,
    NamingStrategyLocator {
        @NonNull
        default public ConversionService getConversionService() {
            return ConversionService.SHARED;
        }

        default public boolean hasView(Class<?> ... views) {
            return false;
        }

        @Internal
        @Nullable
        public <B, P> SerializationReference<B, P> resolveReference(@NonNull SerializationReference<B, P> var1);
    }
}

