/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.config.naming;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.serde.config.naming.IdentityStrategy;
import io.micronaut.serde.config.naming.KebabCaseStrategy;
import io.micronaut.serde.config.naming.LowerCamelCaseStrategy;
import io.micronaut.serde.config.naming.LowerCaseStrategy;
import io.micronaut.serde.config.naming.LowerDotCaseStrategy;
import io.micronaut.serde.config.naming.SnakeCaseStrategy;
import io.micronaut.serde.config.naming.UpperCamelCaseStrategy;
import io.micronaut.serde.config.naming.UpperCamelCaseStrategyWithSpaces;
import java.util.Optional;

public interface PropertyNamingStrategy {
    public static final PropertyNamingStrategy IDENTITY = new IdentityStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE_WITH_SPACES = new UpperCamelCaseStrategyWithSpaces();
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new LowerCamelCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy LOWER_DOT_CASE = new LowerDotCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();

    @NonNull
    public String translate(@NonNull AnnotatedElement var1);

    public static Optional<PropertyNamingStrategy> forName(String namingStrategy) {
        if (StringUtils.isNotEmpty(namingStrategy)) {
            switch (namingStrategy) {
                case "KEBAB_CASE": 
                case "io.micronaut.serde.config.naming.KebabCaseStrategy": {
                    return Optional.of(KEBAB_CASE);
                }
                case "IDENTITY": 
                case "io.micronaut.serde.config.naming.IdentityStrategy": {
                    return Optional.of(IDENTITY);
                }
                case "LOWER_CASE": 
                case "io.micronaut.serde.config.naming.LowerCaseStrategy": {
                    return Optional.of(LOWER_CASE);
                }
                case "LOWER_DOT_CASE": 
                case "io.micronaut.serde.config.naming.LowerDotCaseStrategy": {
                    return Optional.of(LOWER_DOT_CASE);
                }
                case "SNAKE_CASE": 
                case "io.micronaut.serde.config.naming.SnakeCaseStrategy": {
                    return Optional.of(SNAKE_CASE);
                }
                case "UPPER_CAMEL_CASE": 
                case "io.micronaut.serde.config.naming.UpperCamelCaseStrategy": {
                    return Optional.of(UPPER_CAMEL_CASE);
                }
                case "LOWER_CAMEL_CASE": 
                case "io.micronaut.serde.config.naming.LowerCamelCaseStrategy": {
                    return Optional.of(LOWER_CAMEL_CASE);
                }
                case "UPPER_CAMEL_CASE_WITH_SPACES": 
                case "io.micronaut.serde.config.naming.UpperCamelCaseStrategyWithSpaces": {
                    return Optional.of(UPPER_CAMEL_CASE_WITH_SPACES);
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

