/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
public abstract class AbstractStreamDecoder
extends LimitingStream
implements Decoder {
    private boolean currentlyUnwrappingArray = false;

    public AbstractStreamDecoder(@NonNull LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
    }

    @Nullable
    protected abstract TokenType currentToken();

    protected abstract void nextToken() throws IOException;

    protected IOException unexpectedToken(TokenType expected) {
        return this.createDeserializationException("Unexpected token " + this.currentToken() + ", expected " + expected, null);
    }

    protected void preDecodeValue(TokenType currentToken) {
        if (currentToken == TokenType.KEY) {
            throw new IllegalStateException("Haven't parsed field name yet");
        }
    }

    private boolean beginUnwrapArray(TokenType currentToken) throws IOException {
        if (this.currentlyUnwrappingArray) {
            return false;
        }
        if (currentToken != TokenType.START_ARRAY) {
            throw new IllegalStateException("Not an array");
        }
        this.currentlyUnwrappingArray = true;
        this.nextToken();
        return true;
    }

    private boolean endUnwrapArray() throws IOException {
        this.currentlyUnwrappingArray = false;
        if (this.currentToken() == TokenType.END_ARRAY) {
            this.nextToken();
            return true;
        }
        return false;
    }

    @Override
    public void finishStructure(boolean consumeLeftElements) throws IOException {
        TokenType currentToken = this.currentToken();
        if (consumeLeftElements) {
            this.consumeLeftElements(currentToken);
        } else if (currentToken != TokenType.END_ARRAY && currentToken != TokenType.END_OBJECT) {
            throw new IllegalStateException("Not all elements have been consumed yet");
        }
        this.decreaseDepth();
    }

    protected void consumeLeftElements(TokenType currentToken) throws IOException {
        String key;
        while ((key = this.decodeKey()) != null) {
            this.skipValue();
        }
    }

    @Override
    public boolean hasNextArrayValue() {
        return this.currentToken() != TokenType.END_ARRAY;
    }

    protected abstract String getCurrentKey() throws IOException;

    @Override
    @Nullable
    public String decodeKey() throws IOException {
        TokenType currentToken = this.currentToken();
        if (currentToken == TokenType.END_OBJECT) {
            return null;
        }
        if (currentToken != TokenType.KEY) {
            throw new IllegalStateException("Not at a field name");
        }
        String fieldName = this.getCurrentKey();
        this.nextToken();
        return fieldName;
    }

    @Override
    @NonNull
    public final Decoder decodeArray(Argument<?> type) throws IOException {
        return this.decodeArray0(this.currentToken());
    }

    protected AbstractStreamDecoder decodeArray0(TokenType currentToken) throws IOException {
        this.preDecodeValue(currentToken);
        if (currentToken != TokenType.START_ARRAY) {
            throw this.unexpectedToken(TokenType.START_ARRAY);
        }
        this.increaseDepth();
        this.nextToken();
        return this;
    }

    @Override
    @NonNull
    public final Decoder decodeObject(Argument<?> type) throws IOException {
        return this.decodeObject0(this.currentToken());
    }

    protected AbstractStreamDecoder decodeObject0(TokenType currentToken) throws IOException {
        this.preDecodeValue(currentToken);
        if (currentToken != TokenType.START_OBJECT) {
            throw this.unexpectedToken(TokenType.START_OBJECT);
        }
        this.increaseDepth();
        this.nextToken();
        return this;
    }

    protected abstract String coerceScalarToString(TokenType var1) throws IOException;

    @Override
    @NonNull
    public String decodeString() throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case STRING: {
                String text = this.getString();
                this.nextToken();
                return text;
            }
            case NUMBER: 
            case BOOLEAN: 
            case OTHER: {
                String value = this.coerceScalarToString(currentToken);
                this.nextToken();
                return value;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray(currentToken)) break;
                String unwrapped = this.decodeString();
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.STRING);
    }

    protected abstract String getString() throws IOException;

    protected abstract boolean getBoolean() throws IOException;

    @Override
    public final boolean decodeBoolean() throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool;
            }
            case NUMBER: {
                double number = this.getDouble();
                this.nextToken();
                return number != 0.0;
            }
            case STRING: {
                String string = this.coerceScalarToString(currentToken);
                this.nextToken();
                return string.equals("true");
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray(currentToken)) break;
                boolean unwrapped = this.decodeBoolean();
                if (!this.endUnwrapArray()) break;
                return unwrapped;
            }
        }
        throw this.unexpectedToken(TokenType.BOOLEAN);
    }

    @Override
    public final byte decodeByte() throws IOException {
        return (byte)this.decodeInteger(-128L, 127L);
    }

    @Override
    public final short decodeShort() throws IOException {
        return (short)this.decodeInteger(-32768L, 32767L);
    }

    @Override
    public final char decodeChar() throws IOException {
        return (char)this.decodeInteger(0L, 65535L, true);
    }

    @Override
    public final int decodeInt() throws IOException {
        return this.decodeInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final long decodeLong() throws IOException {
        return this.decodeLong(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private long decodeLong(long min, long max) throws IOException {
        return this.decodeLong(min, max, false);
    }

    private int decodeInteger(long min, long max) throws IOException {
        return this.decodeInteger(min, max, false);
    }

    protected abstract long getLong() throws IOException;

    protected int getInteger() throws IOException {
        return (int)this.getLong();
    }

    protected abstract double getDouble() throws IOException;

    protected abstract BigInteger getBigInteger() throws IOException;

    protected abstract BigDecimal getBigDecimal() throws IOException;

    protected abstract Number getBestNumber() throws IOException;

    protected JsonNode getBestNumberNode() throws IOException {
        Number number = this.getBestNumber();
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            return JsonNode.createNumberNode(number.intValue());
        }
        if (number instanceof Long) {
            return JsonNode.createNumberNode(number.longValue());
        }
        if (number instanceof Float) {
            return JsonNode.createNumberNode(number.floatValue());
        }
        if (number instanceof Double) {
            return JsonNode.createNumberNode(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return JsonNode.createNumberNode((BigInteger)number);
        }
        if (number instanceof BigDecimal) {
            return JsonNode.createNumberNode((BigDecimal)number);
        }
        return JsonNode.createNumberNode(this.getBigDecimal());
    }

    private int decodeInteger(long min, long max, boolean stringsAsChars) throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case STRING: {
                int value;
                String string = this.coerceScalarToString(currentToken);
                if (stringsAsChars) {
                    if (string.length() != 1) {
                        throw this.createDeserializationException("When decoding char value, must give a single character", string);
                    }
                    char c = string.charAt(0);
                    this.nextToken();
                    return c;
                }
                try {
                    value = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
                this.nextToken();
                return value;
            }
            case NUMBER: {
                int number = this.getInteger();
                this.nextToken();
                return number;
            }
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool ? 1 : 0;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray(currentToken)) break;
                int unwrapped = this.decodeInteger(min, max);
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one integer, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.NUMBER);
    }

    private long decodeLong(long min, long max, boolean stringsAsChars) throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case STRING: {
                long value;
                String string = this.coerceScalarToString(currentToken);
                if (stringsAsChars) {
                    if (string.length() != 1) {
                        throw this.createDeserializationException("When decoding char value, must give a single character", string);
                    }
                    char c = string.charAt(0);
                    this.nextToken();
                    return c;
                }
                try {
                    value = Long.parseLong(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to integer", string);
                }
                this.nextToken();
                return value;
            }
            case NUMBER: {
                long number = this.getLong();
                this.nextToken();
                return number;
            }
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool ? 1L : 0L;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray(currentToken)) break;
                long unwrapped = this.decodeLong(min, max);
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one integer, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.NUMBER);
    }

    @Override
    public final float decodeFloat() throws IOException {
        return (float)this.decodeDouble();
    }

    @Override
    public final double decodeDouble() throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case NUMBER: {
                double value = this.getDouble();
                this.nextToken();
                return value;
            }
            case STRING: {
                double number;
                String string = this.coerceScalarToString(currentToken);
                try {
                    number = Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    throw this.createDeserializationException("Unable to coerce string to double", string);
                }
                this.nextToken();
                return number;
            }
            case BOOLEAN: {
                boolean bool = this.getBoolean();
                this.nextToken();
                return bool ? 1.0 : 0.0;
            }
            case START_ARRAY: {
                if (!this.beginUnwrapArray(currentToken)) break;
                double unwrapped = this.decodeDouble();
                if (this.endUnwrapArray()) {
                    return unwrapped;
                }
                throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
            }
        }
        throw this.unexpectedToken(TokenType.NUMBER);
    }

    @Override
    @NonNull
    public final BigInteger decodeBigInteger() throws IOException {
        BigInteger value;
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case NUMBER: {
                value = this.getBigInteger();
                break;
            }
            case STRING: {
                try {
                    value = new BigInteger(this.coerceScalarToString(currentToken));
                }
                catch (NumberFormatException e) {
                    value = BigInteger.ZERO;
                }
                break;
            }
            case BOOLEAN: {
                value = this.getBoolean() ? BigInteger.ONE : BigInteger.ZERO;
                break;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(currentToken)) {
                    BigInteger unwrapped = this.decodeBigInteger();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
            }
            default: {
                throw this.unexpectedToken(TokenType.NUMBER);
            }
        }
        this.nextToken();
        return value;
    }

    @Override
    @NonNull
    public final BigDecimal decodeBigDecimal() throws IOException {
        BigDecimal value;
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case NUMBER: {
                value = this.getBigDecimal();
                break;
            }
            case STRING: {
                try {
                    value = new BigDecimal(this.coerceScalarToString(currentToken));
                }
                catch (NumberFormatException e) {
                    value = BigDecimal.ZERO;
                }
                break;
            }
            case BOOLEAN: {
                value = this.getBoolean() ? BigDecimal.ONE : BigDecimal.ZERO;
                break;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(currentToken)) {
                    BigDecimal unwrapped = this.decodeBigDecimal();
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
            }
            default: {
                throw this.unexpectedToken(TokenType.NUMBER);
            }
        }
        this.nextToken();
        return value;
    }

    protected final <T> T decodeNumber(TokenType currentToken, ValueDecoder<T> fromNumberToken, Function<String, T> fromString, T zero, T one) throws IOException {
        T value;
        this.preDecodeValue(currentToken);
        switch (currentToken) {
            case NUMBER: {
                value = fromNumberToken.decode(this);
                break;
            }
            case STRING: {
                try {
                    value = fromString.apply(this.coerceScalarToString(currentToken));
                }
                catch (NumberFormatException e) {
                    value = zero;
                }
                break;
            }
            case BOOLEAN: {
                value = this.getBoolean() ? one : zero;
                break;
            }
            case START_ARRAY: {
                if (this.beginUnwrapArray(currentToken)) {
                    T unwrapped = this.decodeNumber(currentToken, fromNumberToken, fromString, zero, one);
                    if (this.endUnwrapArray()) {
                        return unwrapped;
                    }
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
            }
            default: {
                throw this.unexpectedToken(TokenType.NUMBER);
            }
        }
        this.nextToken();
        return value;
    }

    protected final <T> T decodeCustom(ValueDecoder<T> readFunction) throws IOException {
        return this.decodeCustom(readFunction, true);
    }

    protected final <T> T decodeCustom(ValueDecoder<T> readFunction, boolean callNext) throws IOException {
        this.preDecodeValue(this.currentToken());
        T value = readFunction.decode(this);
        if (callNext) {
            this.nextToken();
        }
        return value;
    }

    @Override
    public final boolean decodeNull() throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        if (currentToken == TokenType.NULL) {
            this.nextToken();
            return true;
        }
        return false;
    }

    @Override
    public Decoder decodeBuffer() throws IOException {
        JsonNode node = this.decodeNode();
        return JsonNodeDecoder.create(node, this.ourLimits());
    }

    @Override
    @NonNull
    public JsonNode decodeNode() throws IOException {
        TokenType currentToken = this.currentToken();
        switch (currentToken) {
            case START_OBJECT: {
                return AbstractStreamDecoder.decodeObjectNode((AbstractStreamDecoder)this.decodeObject());
            }
            case START_ARRAY: {
                return AbstractStreamDecoder.decodeArrayNode((AbstractStreamDecoder)this.decodeArray());
            }
            case STRING: {
                return JsonNode.createStringNode(this.decodeString());
            }
            case NUMBER: {
                this.preDecodeValue(currentToken);
                JsonNode bestNumberNode = this.getBestNumberNode();
                this.nextToken();
                return bestNumberNode;
            }
            case BOOLEAN: {
                return JsonNode.createBooleanNode(this.decodeBoolean());
            }
            case NULL: {
                this.decodeNull();
                return JsonNode.nullNode();
            }
        }
        throw this.createDeserializationException("Unexpected token " + currentToken + ", expected value", null);
    }

    private static JsonNode decodeObjectNode(AbstractStreamDecoder elementDecoder) throws IOException {
        String key;
        LinkedHashMap<String, JsonNode> result = new LinkedHashMap<String, JsonNode>();
        while ((key = elementDecoder.decodeKey()) != null) {
            result.put(key, elementDecoder.decodeNode());
        }
        elementDecoder.finishStructure();
        return JsonNode.createObjectNode(result);
    }

    private static JsonNode decodeArrayNode(AbstractStreamDecoder elementDecoder) throws IOException {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        while (elementDecoder.hasNextArrayValue()) {
            result.add(elementDecoder.decodeNode());
        }
        elementDecoder.finishStructure();
        return JsonNode.createArrayNode(result);
    }

    @Override
    @Nullable
    public final Object decodeArbitrary() throws IOException {
        RootBuilder root;
        for (ArbitraryBuilder currentStructure = root = new RootBuilder(this); currentStructure != null; currentStructure = currentStructure.proceed()) {
        }
        return root.result;
    }

    protected abstract void skipChildren() throws IOException;

    @Override
    public final void skipValue() throws IOException {
        TokenType currentToken = this.currentToken();
        this.preDecodeValue(currentToken);
        this.skipChildren();
        this.nextToken();
    }

    protected static enum TokenType {
        START_ARRAY,
        END_ARRAY,
        START_OBJECT,
        END_OBJECT,
        KEY,
        NUMBER,
        STRING,
        BOOLEAN,
        NULL,
        OTHER;

    }

    @Internal
    public static interface ValueDecoder<R> {
        public R decode(AbstractStreamDecoder var1) throws IOException;
    }

    private static final class RootBuilder
    extends ArbitraryBuilder {
        boolean done = false;
        Object result;

        RootBuilder(AbstractStreamDecoder decoder) {
            super(null, decoder);
        }

        @Override
        void put(String key, Object value) {
            this.result = value;
            this.done = true;
        }

        @Override
        String decodeKey() {
            return !this.done ? "" : null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class ArbitraryBuilder {
        final ArbitraryBuilder parent;
        final AbstractStreamDecoder elementDecoder;

        ArbitraryBuilder(ArbitraryBuilder parent, AbstractStreamDecoder elementDecoder) {
            this.parent = parent;
            this.elementDecoder = elementDecoder;
        }

        abstract String decodeKey() throws IOException;

        abstract void put(String var1, Object var2);

        ArbitraryBuilder proceed() throws IOException {
            String key = this.decodeKey();
            if (key != null) {
                TokenType currentToken = this.elementDecoder.currentToken();
                switch (currentToken) {
                    case START_OBJECT: {
                        MapBuilder map = new MapBuilder(this, this.elementDecoder.decodeObject0(currentToken));
                        this.put(key, map.items);
                        return map;
                    }
                    case START_ARRAY: {
                        ListBuilder list = new ListBuilder(this, this.elementDecoder.decodeArray0(currentToken));
                        this.put(key, list.items);
                        return list;
                    }
                    case STRING: {
                        this.put(key, this.elementDecoder.decodeString());
                        return this;
                    }
                    case NUMBER: {
                        this.elementDecoder.preDecodeValue(currentToken);
                        this.put(key, this.elementDecoder.getBestNumber());
                        this.elementDecoder.nextToken();
                        return this;
                    }
                    case BOOLEAN: {
                        this.put(key, this.elementDecoder.decodeBoolean());
                        return this;
                    }
                    case NULL: {
                        this.elementDecoder.decodeNull();
                        this.put(key, null);
                        return this;
                    }
                }
                throw this.elementDecoder.createDeserializationException("Unexpected token " + currentToken + ", expected value", null);
            }
            return this.parent;
        }
    }

    private static final class MapBuilder
    extends ArbitraryBuilder {
        final Map<String, Object> items = new LinkedHashMap<String, Object>();

        MapBuilder(ArbitraryBuilder parent, AbstractStreamDecoder elementDecoder) {
            super(parent, elementDecoder);
        }

        @Override
        void put(String key, Object value) {
            this.items.put(key, value);
        }

        @Override
        String decodeKey() throws IOException {
            String key = this.elementDecoder.decodeKey();
            if (key == null) {
                this.elementDecoder.finishStructure();
            }
            return key;
        }
    }

    private static final class ListBuilder
    extends ArbitraryBuilder {
        final List<Object> items = new ArrayList<Object>();

        ListBuilder(ArbitraryBuilder parent, AbstractStreamDecoder decoder) {
            super(parent, decoder);
        }

        @Override
        void put(String key, Object value) {
            this.items.add(value);
        }

        @Override
        String decodeKey() throws IOException {
            if (this.elementDecoder.hasNextArrayValue()) {
                return "";
            }
            this.elementDecoder.finishStructure();
            return null;
        }
    }
}

