/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.embedded;

import io.micronaut.context.env.PropertyExpressionResolver;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.testresources.core.LazyTestResourcesExpressionResolver;
import io.micronaut.testresources.core.PropertyResolverSupport;
import io.micronaut.testresources.core.TestResourcesResolver;
import io.micronaut.testresources.embedded.TestResourcesResolverLoader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedTestResourcesPropertyExpressionResolver
extends LazyTestResourcesExpressionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedTestResourcesPropertyExpressionResolver.class);

    public EmbeddedTestResourcesPropertyExpressionResolver() {
        super(new Delegate());
    }

    private static class Delegate
    implements PropertyExpressionResolver {
        private final TestResourcesResolverLoader loader = TestResourcesResolverLoader.getInstance();

        private Delegate() {
        }

        @Override
        public <T> Optional<T> resolve(PropertyResolver propertyResolver, ConversionService conversionService, String expression, Class<T> requiredType) {
            List<TestResourcesResolver> resolvers = this.loader.getResolvers();
            Map<String, Object> testProperties = propertyResolver.getProperties("test-resources");
            for (TestResourcesResolver resolver : resolvers) {
                Map<String, Object> props;
                Optional<String> resolve;
                if (!PropertyResolverSupport.canResolveExpression(propertyResolver, resolver, expression, testProperties) || !(resolve = resolver.resolve(expression, props = PropertyResolverSupport.resolveRequiredProperties(expression, propertyResolver, resolver), testProperties)).isPresent()) continue;
                String resolvedValue = resolve.get();
                LOGGER.debug("Resolved expression '{}' to '{}'", (Object)expression, (Object)resolvedValue);
                return conversionService.convert((Object)resolvedValue, requiredType);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Test resources cannot resolve expression '{}'", (Object)expression);
            }
            return Optional.empty();
        }
    }
}

