/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.server;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.testresources.server.AccessConfiguration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Filter(value={"/**"})
public class AccessFilter
implements HttpServerFilter {
    private final AccessConfiguration accessConfiguration;

    public AccessFilter(AccessConfiguration accessConfiguration) {
        this.accessConfiguration = accessConfiguration;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        if (request.getRemoteAddress().getAddress().isLoopbackAddress()) {
            String clientToken;
            String serverToken = this.accessConfiguration.getAccessToken();
            if (serverToken != null && !serverToken.equals(clientToken = (String)request.getHeaders().get("Access-Token"))) {
                return Flux.just(HttpResponse.unauthorized());
            }
            return chain.proceed(request);
        }
        return Flux.just(HttpResponse.unauthorized());
    }
}

