/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.web.router.AbstractRouteMatch;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.UriRouteMatch;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
class DefaultUriRouteMatch<T, R>
extends AbstractRouteMatch<T, R>
implements UriRouteMatch<T, R> {
    private final UriMatchInfo matchInfo;
    private final UriRouteInfo<T, R> uriRouteInfo;
    private final Charset defaultCharset;

    DefaultUriRouteMatch(UriMatchInfo matchInfo, UriRouteInfo<T, R> routeInfo, Charset defaultCharset, ConversionService conversionService) {
        super(routeInfo, conversionService);
        this.matchInfo = matchInfo;
        this.uriRouteInfo = routeInfo;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public String getUri() {
        return this.matchInfo.getUri();
    }

    @Override
    public Map<String, Object> getVariableValues() {
        Map<String, Object> variables = this.matchInfo.getVariableValues();
        if (CollectionUtils.isNotEmpty(variables)) {
            String charset = this.defaultCharset.toString();
            LinkedHashMap<String, Object> decoded = CollectionUtils.newLinkedHashMap(variables.size());
            variables.forEach((k, v) -> {
                if (v instanceof CharSequence) {
                    try {
                        v = URLDecoder.decode(v.toString(), charset);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                decoded.put((String)k, v);
            });
            return decoded;
        }
        return variables;
    }

    @Override
    public List<UriMatchVariable> getVariables() {
        return this.matchInfo.getVariables();
    }

    @Override
    public Map<String, UriMatchVariable> getVariableMap() {
        return this.matchInfo.getVariableMap();
    }

    @Override
    public UriRouteInfo<T, R> getRouteInfo() {
        return this.uriRouteInfo;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.uriRouteInfo.getHttpMethod();
    }

    public String toString() {
        return this.uriRouteInfo.getHttpMethod() + " - " + this.matchInfo.getUri();
    }
}

