/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.command.DockerCmd;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;

public final class AuditLogger {
    private static final Logger log = LoggerFactory.getLogger(AuditLogger.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String MDC_PREFIX = AuditLogger.class.getCanonicalName();

    public static void doLog(@NotNull String action, @Nullable String image, @Nullable String containerId, @NotNull DockerCmd<?> cmd) {
        AuditLogger.doLog(action, image, containerId, cmd, null);
    }

    public static void doLog(@NotNull String action, @Nullable String image, @Nullable String containerId, @NotNull DockerCmd<?> cmd, @Nullable Exception e) {
        if (!log.isTraceEnabled()) {
            return;
        }
        MDC.put(MDC_PREFIX + ".Action", Strings.nullToEmpty(action));
        MDC.put(MDC_PREFIX + ".Image", Strings.nullToEmpty(image));
        MDC.put(MDC_PREFIX + ".ContainerId", Strings.nullToEmpty(containerId));
        try {
            MDC.put(MDC_PREFIX + ".Command", objectMapper.writeValueAsString(cmd));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        if (e != null) {
            MDC.put(MDC_PREFIX + ".Exception", e.getLocalizedMessage());
            log.trace("{} action with image: {}, containerId: {}", action, image, containerId, e);
        } else {
            log.trace("{} action with image: {}, containerId: {}", action, image, containerId);
        }
        MDC.remove(MDC_PREFIX + ".Action");
        MDC.remove(MDC_PREFIX + ".Image");
        MDC.remove(MDC_PREFIX + ".ContainerId");
        MDC.remove(MDC_PREFIX + ".Command");
        MDC.remove(MDC_PREFIX + ".Exception");
    }

    public static void doComposeLog(@NotNull String[] commandParts, @Nullable List<String> env) {
        if (!log.isTraceEnabled()) {
            return;
        }
        MDC.put(MDC_PREFIX + ".Action", "COMPOSE");
        if (env != null) {
            MDC.put(MDC_PREFIX + ".Compose.Env", env.toString());
        }
        String command = StringUtils.join((Object[])commandParts, ' ');
        MDC.put(MDC_PREFIX + ".Compose.Command", command);
        log.trace("COMPOSE action with command: {}, env: {}", (Object)command, (Object)env);
        MDC.remove(MDC_PREFIX + ".Action");
        MDC.remove(MDC_PREFIX + ".Compose.Command");
        MDC.remove(MDC_PREFIX + ".Compose.Env");
    }

    private AuditLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

