/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import org.testcontainers.DockerClientFactory;
import org.testcontainers.dockerclient.DockerMachineClientProviderStrategy;
import org.testcontainers.utility.ComparableVersion;

public class TestEnvironment {
    private TestEnvironment() {
    }

    public static boolean dockerApiAtLeast(String minimumVersion) {
        ComparableVersion min = new ComparableVersion(minimumVersion);
        ComparableVersion current = new ComparableVersion(DockerClientFactory.instance().getActiveApiVersion());
        return current.compareTo(min) >= 0;
    }

    public static boolean dockerExecutionDriverSupportsExec() {
        String executionDriver = DockerClientFactory.instance().getActiveExecutionDriver();
        return executionDriver == null || !executionDriver.startsWith("lxc");
    }

    public static boolean dockerIsDockerMachine() {
        return DockerClientFactory.instance().isUsing(DockerMachineClientProviderStrategy.class);
    }
}

