/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.DecimalMaxValidator;
import io.micronaut.validation.validator.constraints.DecimalMinValidator;
import io.micronaut.validation.validator.constraints.DigitsValidator;
import io.micronaut.validation.validator.constraints.SizeValidator;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;

@Introspected(accessKind={Introspected.AccessKind.FIELD})
final class InternalConstraintValidators {
    final ConstraintValidator<AssertFalse, Boolean> assertFalseValidator = (value, annotationMetadata, context) -> value == null || value == false;
    final ConstraintValidator<AssertTrue, Boolean> assertTrueValidator = (value, annotationMetadata, context) -> value == null || value != false;
    final DecimalMaxValidator<CharSequence> decimalMaxValidatorCharSequence = (value, bigDecimal) -> new BigDecimal(value.toString()).compareTo(bigDecimal);
    final DecimalMaxValidator<Number> decimalMaxValidatorNumber = InternalConstraintValidators::compareNumber;
    final DecimalMinValidator<CharSequence> decimalMinValidatorCharSequence = (value, bigDecimal) -> new BigDecimal(value.toString()).compareTo(bigDecimal);
    final DecimalMinValidator<Number> decimalMinValidatorNumber = InternalConstraintValidators::compareNumber;
    final DigitsValidator<Number> digitsValidatorNumber = value -> {
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue;
        }
        return new BigDecimal(value.toString());
    };
    final DigitsValidator<CharSequence> digitsValidatorCharSequence = value -> new BigDecimal(value.toString());
    final ConstraintValidator<Max, Number> maxNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Long max = (Long)annotationMetadata.getValue(Long.class).orElseThrow(() -> new ValidationException("@Max annotation specified without value"));
        if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            return intValue.compareTo(BigInteger.valueOf(max)) <= 0;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.compareTo(BigDecimal.valueOf(max)) <= 0;
        }
        return value.longValue() <= max;
    };
    final ConstraintValidator<Min, Number> minNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Long max = (Long)annotationMetadata.getValue(Long.class).orElseThrow(() -> new ValidationException("@Min annotation specified without value"));
        if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            return intValue.compareTo(BigInteger.valueOf(max)) >= 0;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.compareTo(BigDecimal.valueOf(max)) >= 0;
        }
        return value.longValue() >= max;
    };
    final ConstraintValidator<Negative, Number> negativeNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.signum() < 0;
        }
        if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            return intValue.signum() < 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() < 0.0;
        }
        return value.longValue() < 0L;
    };
    final ConstraintValidator<NegativeOrZero, Number> negativeOrZeroNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.signum() <= 0;
        }
        if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            return intValue.signum() <= 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() <= 0.0;
        }
        return value.longValue() <= 0L;
    };
    final ConstraintValidator<Positive, Number> positiveNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.signum() > 0;
        }
        if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            return intValue.signum() > 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() > 0.0;
        }
        return value.longValue() > 0L;
    };
    final ConstraintValidator<PositiveOrZero, Number> positiveOrZeroNumberValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            return decimalValue.signum() >= 0;
        }
        if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            return intValue.signum() >= 0;
        }
        if (value instanceof Double || value instanceof Float || value instanceof DoubleAdder || value instanceof DoubleAccumulator) {
            return value.doubleValue() >= 0.0;
        }
        return value.longValue() >= 0L;
    };
    final ConstraintValidator<NotBlank, CharSequence> notBlankValidator = (value, annotationMetadata, context) -> StringUtils.isNotEmpty((CharSequence)value) && !value.toString().isBlank();
    final ConstraintValidator<NotNull, Object> notNullValidator = (value, annotationMetadata, context) -> value != null;
    final ConstraintValidator<Null, Object> nullValidator = (value, annotationMetadata, context) -> value == null;
    final ConstraintValidator<NotEmpty, byte[]> notEmptyByteArrayValidator = (value, annotationMetadata, context) -> value != null && ((byte[])value).length > 0;
    final ConstraintValidator<NotEmpty, char[]> notEmptyCharArrayValidator = (value, annotationMetadata, context) -> value != null && ((char[])value).length > 0;
    final ConstraintValidator<NotEmpty, boolean[]> notEmptyBooleanArrayValidator = (value, annotationMetadata, context) -> value != null && ((boolean[])value).length > 0;
    final ConstraintValidator<NotEmpty, double[]> notEmptyDoubleArrayValidator = (value, annotationMetadata, context) -> value != null && ((double[])value).length > 0;
    final ConstraintValidator<NotEmpty, float[]> notEmptyFloatArrayValidator = (value, annotationMetadata, context) -> value != null && ((float[])value).length > 0;
    final ConstraintValidator<NotEmpty, int[]> notEmptyIntArrayValidator = (value, annotationMetadata, context) -> value != null && ((int[])value).length > 0;
    final ConstraintValidator<NotEmpty, long[]> notEmptyLongArrayValidator = (value, annotationMetadata, context) -> value != null && ((long[])value).length > 0;
    final ConstraintValidator<NotEmpty, Object[]> notEmptyObjectArrayValidator = (value, annotationMetadata, context) -> value != null && ((Object[])value).length > 0;
    final ConstraintValidator<NotEmpty, short[]> notEmptyShortArrayValidator = (value, annotationMetadata, context) -> value != null && ((short[])value).length > 0;
    final ConstraintValidator<NotEmpty, CharSequence> notEmptyCharSequenceValidator = (value, annotationMetadata, context) -> StringUtils.isNotEmpty((CharSequence)value);
    final ConstraintValidator<NotEmpty, Collection> notEmptyCollectionValidator = (value, annotationMetadata, context) -> CollectionUtils.isNotEmpty((Collection)value);
    final ConstraintValidator<NotEmpty, Map> notEmptyMapValidator = (value, annotationMetadata, context) -> CollectionUtils.isNotEmpty((Map)value);
    final SizeValidator<Object[]> sizeObjectArrayValidator = value -> ((Object[])value).length;
    final SizeValidator<byte[]> sizeByteArrayValidator = value -> ((byte[])value).length;
    final SizeValidator<char[]> sizeCharArrayValidator = value -> ((char[])value).length;
    final SizeValidator<boolean[]> sizeBooleanArrayValidator = value -> ((boolean[])value).length;
    final SizeValidator<double[]> sizeDoubleArrayValidator = value -> ((double[])value).length;
    final SizeValidator<float[]> sizeFloatArrayValidator = value -> ((float[])value).length;
    final SizeValidator<int[]> sizeIntArrayValidator = value -> ((int[])value).length;
    final SizeValidator<long[]> sizeLongArrayValidator = value -> ((long[])value).length;
    final SizeValidator<short[]> sizeShortArrayValidator = value -> ((short[])value).length;
    final SizeValidator<CharSequence> sizeCharSequenceValidator = CharSequence::length;
    final SizeValidator<Collection<?>> sizeCollectionValidator = Collection::size;
    final SizeValidator<Map<?, ?>> sizeMapValidator = Map::size;
    final ConstraintValidator<Past, TemporalAccessor> pastTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) > 0;
    };
    final ConstraintValidator<Past, Date> pastDateConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Date comparable = Date.from(context.getClockProvider().getClock().instant());
        return comparable.compareTo(value) > 0;
    };
    final ConstraintValidator<Past, Calendar> pastCalendarConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(LocalDateTime.now(), context.getClockProvider().getClock());
        return comparable.compareTo(InternalConstraintValidators.toLocalDateTime(value)) > 0;
    };
    final ConstraintValidator<PastOrPresent, TemporalAccessor> pastOrPresentTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) >= 0;
    };
    final ConstraintValidator<PastOrPresent, Date> pastOrPresentDateConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Date comparable = Date.from(context.getClockProvider().getClock().instant());
        return comparable.compareTo(value) >= 0;
    };
    final ConstraintValidator<PastOrPresent, Calendar> pastOrPresentCalendarConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(LocalDateTime.now(), context.getClockProvider().getClock());
        return comparable.compareTo(InternalConstraintValidators.toLocalDateTime(value)) >= 0;
    };
    final ConstraintValidator<Future, TemporalAccessor> futureTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) < 0;
    };
    final ConstraintValidator<Future, Calendar> futureCalendarConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(LocalDateTime.now(), context.getClockProvider().getClock());
        return comparable.compareTo(InternalConstraintValidators.toLocalDateTime(value)) < 0;
    };
    final ConstraintValidator<Future, Date> futureDateConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Date comparable = Date.from(context.getClockProvider().getClock().instant());
        return comparable.compareTo(value) < 0;
    };
    final ConstraintValidator<FutureOrPresent, TemporalAccessor> futureOrPresentTemporalAccessorConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(value, context.getClockProvider().getClock());
        return comparable.compareTo((TemporalAccessor)value) <= 0;
    };
    final ConstraintValidator<FutureOrPresent, Date> futureOrPresentDateConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Date comparable = Date.from(context.getClockProvider().getClock().instant());
        return comparable.compareTo(value) <= 0;
    };
    final ConstraintValidator<FutureOrPresent, Calendar> futureOrPresentCalendarConstraintValidator = (value, annotationMetadata, context) -> {
        if (value == null) {
            return true;
        }
        Comparable<? extends TemporalAccessor> comparable = InternalConstraintValidators.getNow(LocalDateTime.now(), context.getClockProvider().getClock());
        return comparable.compareTo(InternalConstraintValidators.toLocalDateTime(value)) <= 0;
    };

    InternalConstraintValidators() {
    }

    private static int compareNumber(@NonNull Number value, @NonNull BigDecimal bigDecimal) {
        int result;
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            result = decimalValue.compareTo(bigDecimal);
        } else if (value instanceof BigInteger) {
            BigInteger intValue = (BigInteger)value;
            result = new BigDecimal(intValue).compareTo(bigDecimal);
        } else {
            result = BigDecimal.valueOf(value.doubleValue()).compareTo(bigDecimal);
        }
        return result;
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        TimeZone tz = calendar.getTimeZone();
        ZoneId zid = tz == null ? ZoneId.systemDefault() : tz.toZoneId();
        return LocalDateTime.ofInstant(calendar.toInstant(), zid);
    }

    private static Comparable<? extends TemporalAccessor> getNow(TemporalAccessor value, Clock clock) {
        if (!(value instanceof Comparable)) {
            throw new IllegalArgumentException("TemporalAccessor value must be comparable");
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTime.now(clock);
        }
        if (value instanceof Instant) {
            return Instant.now(clock);
        }
        if (value instanceof ZonedDateTime) {
            return ZonedDateTime.now(clock);
        }
        if (value instanceof OffsetDateTime) {
            return OffsetDateTime.now(clock);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now(clock);
        }
        if (value instanceof LocalTime) {
            return LocalTime.now(clock);
        }
        if (value instanceof OffsetTime) {
            return OffsetTime.now(clock);
        }
        if (value instanceof MonthDay) {
            return MonthDay.now(clock);
        }
        if (value instanceof Year) {
            return Year.now(clock);
        }
        if (value instanceof YearMonth) {
            return YearMonth.now(clock);
        }
        if (value instanceof HijrahDate) {
            return HijrahDate.now(clock);
        }
        if (value instanceof JapaneseDate) {
            return JapaneseDate.now(clock);
        }
        if (value instanceof ThaiBuddhistDate) {
            return ThaiBuddhistDate.now(clock);
        }
        if (value instanceof MinguoDate) {
            return MinguoDate.now(clock);
        }
        throw new IllegalArgumentException("TemporalAccessor value type not supported: " + value.getClass());
    }

    public static List<Map.Entry<Argument<Object>, ConstraintValidator<?, ?>>> getConstraintValidators() {
        InternalConstraintValidators bean = new InternalConstraintValidators();
        BeanWrapper wrapper = BeanWrapper.findWrapper(InternalConstraintValidators.class, (Object)bean).orElse(null);
        if (wrapper == null) {
            throw new IllegalArgumentException("Cannot retrieve constraint validators");
        }
        return wrapper.getBeanProperties().stream().map(p -> Map.entry(p.asArgument(), (ConstraintValidator)p.get((Object)bean))).toList();
    }
}

