/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class AlterCollectionParam {
    private final String collectionName;
    private final Map<String, String> properties = new HashMap<String, String>();

    private AlterCollectionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        if (builder.ttlSeconds >= 0) {
            this.properties.put("collection.ttl.seconds", Integer.toString(builder.ttlSeconds));
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "AlterCollectionParam{collectionName='" + this.collectionName + '\'' + ", properties='" + this.properties.toString() + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class Builder {
        private String collectionName;
        private Integer ttlSeconds = -1;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withTTL(@NonNull Integer ttlSeconds) {
            if (ttlSeconds == null) {
                throw new NullPointerException("ttlSeconds is marked non-null but is null");
            }
            if (ttlSeconds < 0) {
                throw new ParamException("The ttlSeconds value should be 0 or greater");
            }
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public AlterCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new AlterCollectionParam(this);
        }
    }
}

