/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class CreateDatabaseParam {
    private final String databaseName;

    private CreateDatabaseParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "CreateDatabaseParam{databaseName='" + this.databaseName + '\'' + '}';
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static final class Builder {
        private String databaseName;

        private Builder() {
        }

        public Builder withDatabaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked non-null but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public CreateDatabaseParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.databaseName, "Database name");
            return new CreateDatabaseParam(this);
        }
    }
}

