/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DropResourceGroupParam {
    private final String groupName;

    private DropResourceGroupParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.groupName = builder.groupName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "DropResourceGroupParam{groupName='" + this.groupName + '}';
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static final class Builder {
        private String groupName;

        private Builder() {
        }

        public Builder withGroupName(@NonNull String groupName) {
            if (groupName == null) {
                throw new NullPointerException("groupName is marked non-null but is null");
            }
            this.groupName = groupName;
            return this;
        }

        public DropResourceGroupParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.groupName, "Group name");
            return new DropResourceGroupParam(this);
        }
    }
}

