/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.ByteString;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.common.utils.JacksonUtils;
import io.milvus.exception.ParamException;
import io.milvus.grpc.ArrayArray;
import io.milvus.grpc.BoolArray;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DoubleArray;
import io.milvus.grpc.DslType;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FloatArray;
import io.milvus.grpc.HybridSearchRequest;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.IntArray;
import io.milvus.grpc.JSONArray;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.PlaceholderGroup;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.PlaceholderValue;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SparseFloatArray;
import io.milvus.grpc.StringArray;
import io.milvus.grpc.UpsertRequest;
import io.milvus.grpc.VectorField;
import io.milvus.param.MetricType;
import io.milvus.param.collection.FieldType;
import io.milvus.param.dml.AnnSearchParam;
import io.milvus.param.dml.HybridSearchParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.dml.UpsertParam;
import io.milvus.param.dml.ranker.BaseRanker;
import io.milvus.response.DescCollResponseWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ParamUtils {
    private static final Gson GSON_INSTANCE = new Gson();

    private static HashMap<DataType, String> getTypeErrorMsgForColumnInsert() {
        HashMap<DataType, String> typeErrMsg = new HashMap<DataType, String>();
        typeErrMsg.put(DataType.None, "Type mismatch for field '%s': the field type is illegal.");
        typeErrMsg.put(DataType.Bool, "Type mismatch for field '%s': Bool field value type must be Boolean.");
        typeErrMsg.put(DataType.Int8, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be Short or Integer.");
        typeErrMsg.put(DataType.Int16, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be Short or Integer.");
        typeErrMsg.put(DataType.Int32, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be Short or Integer.");
        typeErrMsg.put(DataType.Int64, "Type mismatch for field '%s': Int64 field value type must be Long.");
        typeErrMsg.put(DataType.Float, "Type mismatch for field '%s': Float field value type must be Float.");
        typeErrMsg.put(DataType.Double, "Type mismatch for field '%s': Double field value type must be Double.");
        typeErrMsg.put(DataType.String, "Type mismatch for field '%s': String field value type must be String.");
        typeErrMsg.put(DataType.VarChar, "Type mismatch for field '%s': VarChar field value type must be String, and the string length must shorter than max_length.");
        typeErrMsg.put(DataType.Array, "Type mismatch for field '%s': Array field value type must be List<Object>, each object type must be element_type, and the array length must be shorter than max_capacity.");
        typeErrMsg.put(DataType.FloatVector, "Type mismatch for field '%s': Float vector field's value type must be List<Float>.");
        typeErrMsg.put(DataType.BinaryVector, "Type mismatch for field '%s': Binary vector field's value type must be ByteBuffer.");
        typeErrMsg.put(DataType.Float16Vector, "Type mismatch for field '%s': Float16 vector field's value type must be ByteBuffer.");
        typeErrMsg.put(DataType.BFloat16Vector, "Type mismatch for field '%s': BFloat16 vector field's value type must be ByteBuffer.");
        typeErrMsg.put(DataType.SparseFloatVector, "Type mismatch for field '%s': SparseFloatVector vector field's value type must be SortedMap<Long, Float>.");
        return typeErrMsg;
    }

    private static HashMap<DataType, String> getTypeErrorMsgForRowInsert() {
        HashMap<DataType, String> typeErrMsg = new HashMap<DataType, String>();
        typeErrMsg.put(DataType.None, "Type mismatch for field '%s': the field type is illegal.");
        typeErrMsg.put(DataType.Bool, "Type mismatch for field '%s': Bool field value type must be JsonPrimitive.");
        typeErrMsg.put(DataType.Int8, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be JsonPrimitive of boolean.");
        typeErrMsg.put(DataType.Int16, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be JsonPrimitive of number.");
        typeErrMsg.put(DataType.Int32, "Type mismatch for field '%s': Int32/Int16/Int8 field value type must be JsonPrimitive of number.");
        typeErrMsg.put(DataType.Int64, "Type mismatch for field '%s': Int64 field value type must be JsonPrimitive of number.");
        typeErrMsg.put(DataType.Float, "Type mismatch for field '%s': Float field value type must be JsonPrimitive of number.");
        typeErrMsg.put(DataType.Double, "Type mismatch for field '%s': Double field value type must be JsonPrimitive of number.");
        typeErrMsg.put(DataType.String, "Type mismatch for field '%s': String field value type must be JsonPrimitive of string.");
        typeErrMsg.put(DataType.VarChar, "Type mismatch for field '%s': VarChar field value type must be JsonPrimitive of string, and the string length must shorter than max_length.");
        typeErrMsg.put(DataType.Array, "Type mismatch for field '%s': Array field value type must be JsonArray, each object type must be element_type, and the array length must be shorter than max_capacity.");
        typeErrMsg.put(DataType.FloatVector, "Type mismatch for field '%s': Float vector field's value type must be JsonArray of List<Float>.");
        typeErrMsg.put(DataType.BinaryVector, "Type mismatch for field '%s': Binary vector field's value type must be JsonArray of byte[].");
        typeErrMsg.put(DataType.Float16Vector, "Type mismatch for field '%s': Float16 vector field's value type must be JsonArray of byte[].");
        typeErrMsg.put(DataType.BFloat16Vector, "Type mismatch for field '%s': BFloat16 vector field's value type must be JsonArray of byte[].");
        typeErrMsg.put(DataType.SparseFloatVector, "Type mismatch for field '%s': SparseFloatVector vector field's value type must be JsonObject of Map<Long, Float>.");
        return typeErrMsg;
    }

    public static void checkFieldData(FieldType fieldSchema, InsertParam.Field fieldData) {
        List<?> values = fieldData.getValues();
        ParamUtils.checkFieldData(fieldSchema, values, false);
    }

    private static int calculateBinVectorDim(DataType dataType, int byteCount) {
        if (dataType == DataType.BinaryVector) {
            return byteCount * 8;
        }
        if (byteCount % 2 != 0) {
            String msg = "Incorrect byte count for %s type field, byte count is %d, cannot be evenly divided by 2";
            throw new ParamException(String.format(msg, dataType.name(), byteCount));
        }
        return byteCount / 2;
    }

    public static void checkFieldData(FieldType fieldSchema, List<?> values, boolean verifyElementType) {
        DataType dataType;
        HashMap<DataType, String> errMsgs = ParamUtils.getTypeErrorMsgForColumnInsert();
        DataType dataType2 = dataType = verifyElementType ? fieldSchema.getElementType() : fieldSchema.getDataType();
        if (verifyElementType && values.size() > fieldSchema.getMaxCapacity()) {
            throw new ParamException(String.format("Array field '%s' length: %d exceeds max capacity: %d", fieldSchema.getName(), values.size(), fieldSchema.getMaxCapacity()));
        }
        switch (dataType) {
            case FloatVector: {
                int dim = fieldSchema.getDimension();
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!(value instanceof List)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    List temp = (List)value;
                    for (Object v : temp) {
                        if (v instanceof Float) continue;
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    if (temp.size() == dim) continue;
                    String msg = "Incorrect dimension for field '%s': the no.%d vector's dimension: %d is not equal to field's dimension: %d";
                    throw new ParamException(String.format(msg, fieldSchema.getName(), i, temp.size(), dim));
                }
                break;
            }
            case BinaryVector: 
            case Float16Vector: 
            case BFloat16Vector: {
                int dim = fieldSchema.getDimension();
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (!(value instanceof ByteBuffer)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    ByteBuffer v = (ByteBuffer)value;
                    int real_dim = ParamUtils.calculateBinVectorDim(dataType, v.position());
                    if (real_dim == dim) continue;
                    String msg = "Incorrect dimension for field '%s': the no.%d vector's dimension: %d is not equal to field's dimension: %d";
                    throw new ParamException(String.format(msg, fieldSchema.getName(), i, real_dim, dim));
                }
                break;
            }
            case SparseFloatVector: {
                for (Object value : values) {
                    if (!(value instanceof SortedMap)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    SortedMap m = (SortedMap)value;
                    if (m.isEmpty()) {
                        String msg = "Not allow empty SortedMap for sparse vector field '%s'";
                        throw new ParamException(String.format(msg, fieldSchema.getName()));
                    }
                    if (m.firstKey() instanceof Long && m.get(m.firstKey()) instanceof Float) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Int64: {
                for (Object value : values) {
                    if (value instanceof Long) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Int32: 
            case Int16: 
            case Int8: {
                for (Object value : values) {
                    if (value instanceof Short || value instanceof Integer) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Bool: {
                for (Object value : values) {
                    if (value instanceof Boolean) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Float: {
                for (Object value : values) {
                    if (value instanceof Float) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Double: {
                for (Object value : values) {
                    if (value instanceof Double) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case VarChar: 
            case String: {
                for (Object value : values) {
                    if (!(value instanceof String)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    if (((String)value).length() <= fieldSchema.getMaxLength()) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case JSON: {
                for (Object value : values) {
                    if (value instanceof JsonElement) continue;
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                break;
            }
            case Array: {
                for (Object value : values) {
                    if (!(value instanceof List)) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    List array = (List)value;
                    if (array.size() > fieldSchema.getMaxCapacity()) {
                        throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                    }
                    ParamUtils.checkFieldData(fieldSchema, array, true);
                }
                break;
            }
            default: {
                throw new ParamException("Unsupported data type returned by FieldData");
            }
        }
    }

    public static Object checkFieldValue(FieldType fieldSchema, JsonElement value) {
        HashMap<DataType, String> errMsgs = ParamUtils.getTypeErrorMsgForRowInsert();
        DataType dataType = fieldSchema.getDataType();
        switch (dataType) {
            case FloatVector: {
                if (!value.isJsonArray()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                int dim = fieldSchema.getDimension();
                try {
                    List vector = (List)GSON_INSTANCE.fromJson(value, new TypeToken<List<Float>>(){}.getType());
                    if (vector.size() != dim) {
                        String msg = "Incorrect dimension for field '%s': dimension: %d is not equal to field's dimension: %d";
                        throw new ParamException(String.format(msg, fieldSchema.getName(), vector.size(), dim));
                    }
                    return vector;
                }
                catch (JsonSyntaxException e) {
                    throw new ParamException(String.format("Unable to convert JsonArray to List<Float> for field '%s'. Reason: %s", fieldSchema.getName(), e.getCause().getMessage()));
                }
            }
            case BinaryVector: 
            case Float16Vector: 
            case BFloat16Vector: {
                if (!value.isJsonArray()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                int dim = fieldSchema.getDimension();
                try {
                    byte[] v = (byte[])GSON_INSTANCE.fromJson(value, new TypeToken<byte[]>(){}.getType());
                    int real_dim = ParamUtils.calculateBinVectorDim(dataType, v.length);
                    if (real_dim != dim) {
                        String msg = "Incorrect dimension for field '%s': dimension: %d is not equal to field's dimension: %d";
                        throw new ParamException(String.format(msg, fieldSchema.getName(), real_dim, dim));
                    }
                    return ByteBuffer.wrap(v);
                }
                catch (JsonSyntaxException e) {
                    throw new ParamException(String.format("Unable to convert JsonArray to List<Float> for field '%s'. Reason: %s", fieldSchema.getName(), e.getCause().getMessage()));
                }
            }
            case SparseFloatVector: {
                if (!value.isJsonObject()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                try {
                    return GSON_INSTANCE.fromJson(value, new TypeToken<SortedMap<Long, Float>>(){}.getType());
                }
                catch (JsonSyntaxException e) {
                    throw new ParamException(String.format("Unable to convert JsonObject to SortedMap<Long, Float> for field '%s'. Reason: %s", fieldSchema.getName(), e.getCause().getMessage()));
                }
            }
            case Int64: {
                if (!value.isJsonPrimitive()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return value.getAsLong();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                if (!value.isJsonPrimitive()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return value.getAsInt();
            }
            case Bool: {
                if (!value.isJsonPrimitive()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return value.getAsBoolean();
            }
            case Float: {
                if (!value.isJsonPrimitive()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return Float.valueOf(value.getAsFloat());
            }
            case Double: {
                if (!value.isJsonPrimitive()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return value.getAsDouble();
            }
            case VarChar: 
            case String: {
                if (!value.isJsonPrimitive()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                JsonPrimitive p = value.getAsJsonPrimitive();
                if (!p.isString()) {
                    throw new ParamException(String.format("JsonPrimitive should be String type for field '%s'", fieldSchema.getName()));
                }
                String str = p.getAsString();
                if (str.length() > fieldSchema.getMaxLength()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return str;
            }
            case JSON: {
                return value;
            }
            case Array: {
                if (!value.isJsonArray()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                List<Object> array = ParamUtils.convertJsonArray(value.getAsJsonArray(), fieldSchema.getElementType(), fieldSchema.getName());
                if (array.size() > fieldSchema.getMaxCapacity()) {
                    throw new ParamException(String.format(errMsgs.get((Object)dataType), fieldSchema.getName()));
                }
                return array;
            }
        }
        throw new ParamException("Unsupported data type returned by FieldData");
    }

    public static List<Object> convertJsonArray(JsonArray jsonArray, DataType elementType, String fieldName) {
        try {
            switch (elementType) {
                case Int64: {
                    return (List)GSON_INSTANCE.fromJson((JsonElement)jsonArray, new TypeToken<List<Long>>(){}.getType());
                }
                case Int32: 
                case Int16: 
                case Int8: {
                    return (List)GSON_INSTANCE.fromJson((JsonElement)jsonArray, new TypeToken<List<Integer>>(){}.getType());
                }
                case Bool: {
                    return (List)GSON_INSTANCE.fromJson((JsonElement)jsonArray, new TypeToken<List<Boolean>>(){}.getType());
                }
                case Float: {
                    return (List)GSON_INSTANCE.fromJson((JsonElement)jsonArray, new TypeToken<List<Float>>(){}.getType());
                }
                case Double: {
                    return (List)GSON_INSTANCE.fromJson((JsonElement)jsonArray, new TypeToken<List<Double>>(){}.getType());
                }
                case VarChar: {
                    return (List)GSON_INSTANCE.fromJson((JsonElement)jsonArray, new TypeToken<List<String>>(){}.getType());
                }
            }
            throw new ParamException(String.format("Unsupported element type of Array field '%s'", fieldName));
        }
        catch (JsonSyntaxException e) {
            throw new ParamException(String.format("Unable to convert JsonArray to List<Object> for field '%s'. Reason: %s", fieldName, e.getCause().getMessage()));
        }
    }

    public static void CheckNullEmptyString(String target, String name) throws ParamException {
        if (target == null || StringUtils.isBlank((CharSequence)target)) {
            throw new ParamException(name + " cannot be null or empty");
        }
    }

    public static void CheckNullString(String target, String name) throws ParamException {
        if (target == null) {
            throw new ParamException(name + " cannot be null");
        }
    }

    public static ByteString convertPlaceholder(List<?> vectors, PlaceholderType placeType) throws ParamException {
        PlaceholderType plType = PlaceholderType.None;
        ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
        for (Object vector : vectors) {
            ByteBuffer buf;
            if (vector instanceof List) {
                plType = PlaceholderType.FloatVector;
                List list = (List)vector;
                buf = ByteBuffer.allocate(4 * list.size());
                buf.order(ByteOrder.LITTLE_ENDIAN);
                list.forEach(buf::putFloat);
                byte[] array = buf.array();
                ByteString bs = ByteString.copyFrom((byte[])array);
                byteStrings.add(bs);
                continue;
            }
            if (vector instanceof ByteBuffer) {
                plType = PlaceholderType.BinaryVector;
                ByteBuffer buf2 = (ByteBuffer)vector;
                byte[] array = buf2.array();
                ByteString bs = ByteString.copyFrom((byte[])array);
                byteStrings.add(bs);
                continue;
            }
            if (vector instanceof SortedMap) {
                plType = PlaceholderType.SparseFloatVector;
                SortedMap sparse = (SortedMap)vector;
                buf = ParamUtils.encodeSparseFloatVector(sparse);
                ByteString byteString = ByteString.copyFrom((byte[])buf.array());
                byteStrings.add(byteString);
                continue;
            }
            String msg = "Search target vector type is illegal. Only allow List<Float> for FloatVector, ByteBuffer for BinaryVector/Float16Vector/BFloat16Vector, List<SortedMap<Long, Float>> for SparseFloatVector.";
            throw new ParamException(msg);
        }
        if (placeType != PlaceholderType.None) {
            plType = placeType;
        }
        PlaceholderValue.Builder pldBuilder = PlaceholderValue.newBuilder().setTag("$0").setType(plType);
        byteStrings.forEach(pldBuilder::addValues);
        PlaceholderValue plv = pldBuilder.build();
        PlaceholderGroup placeholderGroup = PlaceholderGroup.newBuilder().addPlaceholders(plv).build();
        return placeholderGroup.toByteString();
    }

    public static SearchRequest convertSearchParam(@NonNull SearchParam requestParam) throws ParamException {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        SearchRequest.Builder builder = SearchRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
        if (!requestParam.getPartitionNames().isEmpty()) {
            requestParam.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
            builder.setDbName(requestParam.getDatabaseName());
        }
        ByteString byteStr = ParamUtils.convertPlaceholder(requestParam.getVectors(), requestParam.getPlType());
        builder.setPlaceholderGroup(byteStr);
        builder.setNq(requestParam.getNQ());
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(requestParam.getVectorFieldName()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(requestParam.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(requestParam.getRoundDecimal())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("ignore_growing").setValue(String.valueOf(requestParam.isIgnoreGrowing())).build());
        if (!Objects.equals(requestParam.getMetricType(), MetricType.None.name())) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(requestParam.getMetricType()).build());
        }
        if (!StringUtils.isEmpty((CharSequence)requestParam.getGroupByFieldName())) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("group_by_field").setValue(requestParam.getGroupByFieldName()).build());
        }
        if (null != requestParam.getParams() && !requestParam.getParams().isEmpty()) {
            try {
                Map paramMap = JacksonUtils.fromJson(requestParam.getParams(), Map.class);
                String offset = ((Object)paramMap.getOrDefault("offset", 0)).toString();
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("offset").setValue(offset).build());
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(requestParam.getParams()).build());
            }
            catch (IllegalArgumentException e) {
                throw new ParamException(e.getMessage() + e.getCause().getMessage());
            }
        }
        if (!requestParam.getOutFields().isEmpty()) {
            requestParam.getOutFields().forEach(builder::addOutputFields);
        }
        builder.setDslType(DslType.BoolExprV1);
        if (requestParam.getExpr() != null && !requestParam.getExpr().isEmpty()) {
            builder.setDsl(requestParam.getExpr());
        }
        long guaranteeTimestamp = ParamUtils.getGuaranteeTimestamp(requestParam.getConsistencyLevel(), requestParam.getGuaranteeTimestamp(), requestParam.getGracefulTime());
        builder.setTravelTimestamp(requestParam.getTravelTimestamp());
        builder.setGuaranteeTimestamp(guaranteeTimestamp);
        if (requestParam.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(requestParam.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public static SearchRequest convertAnnSearchParam(@NonNull AnnSearchParam annSearchParam, ConsistencyLevelEnum consistencyLevel) {
        if (annSearchParam == null) {
            throw new NullPointerException("annSearchParam is marked non-null but is null");
        }
        SearchRequest.Builder builder = SearchRequest.newBuilder();
        ByteString byteStr = ParamUtils.convertPlaceholder(annSearchParam.getVectors(), annSearchParam.getPlType());
        builder.setPlaceholderGroup(byteStr);
        builder.setNq(annSearchParam.getNQ());
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(annSearchParam.getVectorFieldName()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(annSearchParam.getTopK())).build());
        if (!Objects.equals(annSearchParam.getMetricType(), MetricType.None.name())) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(annSearchParam.getMetricType()).build());
        }
        String params = "{}";
        if (null != annSearchParam.getParams() && !annSearchParam.getParams().isEmpty()) {
            params = annSearchParam.getParams();
        }
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(params).build());
        builder.setDslType(DslType.BoolExprV1);
        if (annSearchParam.getExpr() != null && !annSearchParam.getExpr().isEmpty()) {
            builder.setDsl(annSearchParam.getExpr());
        }
        if (consistencyLevel == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(consistencyLevel.getCode());
        }
        return builder.build();
    }

    public static HybridSearchRequest convertHybridSearchParam(@NonNull HybridSearchParam requestParam) throws ParamException {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        HybridSearchRequest.Builder builder = HybridSearchRequest.newBuilder().setCollectionName(requestParam.getCollectionName());
        if (!requestParam.getPartitionNames().isEmpty()) {
            requestParam.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
            builder.setDbName(requestParam.getDatabaseName());
        }
        for (AnnSearchParam req : requestParam.getSearchRequests()) {
            SearchRequest searchRequest = ParamUtils.convertAnnSearchParam(req, requestParam.getConsistencyLevel());
            builder.addRequests(searchRequest);
        }
        BaseRanker ranker = requestParam.getRanker();
        Map<String, String> props = ranker.getProperties();
        props.put("limit", String.format("%d", requestParam.getTopK()));
        props.put("round_decimal", String.format("%d", requestParam.getRoundDecimal()));
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(props);
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addRankParams);
        }
        if (!requestParam.getOutFields().isEmpty()) {
            requestParam.getOutFields().forEach(builder::addOutputFields);
        }
        if (requestParam.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(requestParam.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public static QueryRequest convertQueryParam(@NonNull QueryParam requestParam) {
        long limit;
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        long guaranteeTimestamp = ParamUtils.getGuaranteeTimestamp(requestParam.getConsistencyLevel(), requestParam.getGuaranteeTimestamp(), requestParam.getGracefulTime());
        QueryRequest.Builder builder = QueryRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).addAllOutputFields(requestParam.getOutFields()).setExpr(requestParam.getExpr()).setTravelTimestamp(requestParam.getTravelTimestamp()).setGuaranteeTimestamp(guaranteeTimestamp);
        if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
            builder.setDbName(requestParam.getDatabaseName());
        }
        if (requestParam.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(requestParam.getConsistencyLevel().getCode());
        }
        long offset = requestParam.getOffset();
        if (offset > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(offset)).build());
        }
        if ((limit = requestParam.getLimit()) > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("limit").setValue(String.valueOf(limit)).build());
        }
        builder.addQueryParams(KeyValuePair.newBuilder().setKey("ignore_growing").setValue(String.valueOf(requestParam.isIgnoreGrowing())).build());
        return builder.build();
    }

    private static long getGuaranteeTimestamp(ConsistencyLevelEnum consistencyLevel, long guaranteeTimestamp, Long gracefulTime) {
        if (consistencyLevel == null) {
            return 1L;
        }
        switch (consistencyLevel) {
            case STRONG: {
                guaranteeTimestamp = 0L;
                break;
            }
            case BOUNDED: {
                guaranteeTimestamp = new Date().getTime() - gracefulTime;
                break;
            }
            case EVENTUALLY: {
                guaranteeTimestamp = 1L;
            }
        }
        return guaranteeTimestamp;
    }

    public static boolean isVectorDataType(DataType dataType) {
        HashSet<DataType> vectorDataType = new HashSet<DataType>(){
            {
                this.add(DataType.FloatVector);
                this.add(DataType.BinaryVector);
                this.add(DataType.Float16Vector);
                this.add(DataType.BFloat16Vector);
                this.add(DataType.SparseFloatVector);
            }
        };
        return vectorDataType.contains((Object)dataType);
    }

    public static FieldData genFieldData(FieldType fieldType, List<?> objects) {
        return ParamUtils.genFieldData(fieldType, objects, Boolean.FALSE);
    }

    public static FieldData genFieldData(FieldType fieldType, List<?> objects, boolean isDynamic) {
        if (objects == null) {
            throw new ParamException("Cannot generate FieldData from null object");
        }
        DataType dataType = fieldType.getDataType();
        String fieldName = fieldType.getName();
        FieldData.Builder builder = FieldData.newBuilder();
        if (ParamUtils.isVectorDataType(dataType)) {
            VectorField vectorField = ParamUtils.genVectorField(dataType, objects);
            return builder.setFieldName(fieldName).setType(dataType).setVectors(vectorField).build();
        }
        ScalarField scalarField = ParamUtils.genScalarField(fieldType, objects);
        if (isDynamic) {
            return builder.setType(dataType).setScalars(scalarField).setIsDynamic(true).build();
        }
        return builder.setFieldName(fieldName).setType(dataType).setScalars(scalarField).build();
    }

    private static VectorField genVectorField(DataType dataType, List<?> objects) {
        if (dataType == DataType.FloatVector) {
            ArrayList floats = new ArrayList();
            for (Object object : objects) {
                if (object instanceof List) {
                    List list = (List)object;
                    floats.addAll(list);
                    continue;
                }
                throw new ParamException("The type of FloatVector must be List<Float>");
            }
            int dim = floats.size() / objects.size();
            FloatArray floatArray = FloatArray.newBuilder().addAllData(floats).build();
            return VectorField.newBuilder().setDim(dim).setFloatVector(floatArray).build();
        }
        if (dataType == DataType.BinaryVector || dataType == DataType.Float16Vector || dataType == DataType.BFloat16Vector) {
            ByteBuffer totalBuf = null;
            int dim = 0;
            for (Object object : objects) {
                ByteBuffer buf = (ByteBuffer)object;
                if (totalBuf == null) {
                    totalBuf = ByteBuffer.allocate(buf.limit() * objects.size());
                    totalBuf.put(buf.array());
                    dim = ParamUtils.calculateBinVectorDim(dataType, buf.limit());
                    continue;
                }
                totalBuf.put(buf.array());
            }
            assert (totalBuf != null);
            ByteString byteString = ByteString.copyFrom((byte[])totalBuf.array());
            if (dataType == DataType.BinaryVector) {
                return VectorField.newBuilder().setDim(dim).setBinaryVector(byteString).build();
            }
            if (dataType == DataType.Float16Vector) {
                return VectorField.newBuilder().setDim(dim).setFloat16Vector(byteString).build();
            }
            return VectorField.newBuilder().setDim(dim).setBfloat16Vector(byteString).build();
        }
        if (dataType == DataType.SparseFloatVector) {
            SparseFloatArray sparseArray = ParamUtils.genSparseFloatArray(objects);
            return VectorField.newBuilder().setDim(sparseArray.getDim()).setSparseFloatVector(sparseArray).build();
        }
        throw new ParamException("Illegal vector dataType:" + (Object)((Object)dataType));
    }

    public static ByteBuffer encodeSparseFloatVector(SortedMap<Long, Float> sparse) {
        ByteBuffer buf = ByteBuffer.allocate(8 * sparse.size());
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (Map.Entry<Long, Float> entry : sparse.entrySet()) {
            long k = entry.getKey();
            if (k < 0L || k >= (long)Math.pow(2.0, 32.0) - 1L) {
                throw new ParamException("Sparse vector index must be positive and less than 2^32-1");
            }
            ByteBuffer lBuf = ByteBuffer.allocate(8);
            lBuf.order(ByteOrder.LITTLE_ENDIAN);
            lBuf.putLong(k);
            buf.put(lBuf.array(), 0, 4);
            float v = entry.getValue().floatValue();
            if (Float.isNaN(v) || Float.isInfinite(v)) {
                throw new ParamException("Sparse vector value cannot be NaN or Infinite");
            }
            buf.putFloat(entry.getValue().floatValue());
        }
        return buf;
    }

    public static SortedMap<Long, Float> decodeSparseFloatVector(ByteBuffer buf) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        TreeMap<Long, Float> sparse = new TreeMap<Long, Float>();
        long num = buf.limit() / 8;
        for (long j = 0L; j < num; ++j) {
            ByteBuffer pBuf = ByteBuffer.allocate(8);
            pBuf.order(ByteOrder.LITTLE_ENDIAN);
            int offset = 8 * (int)j;
            byte[] aa = buf.array();
            for (int k = offset; k < offset + 4; ++k) {
                pBuf.put(aa[k]);
            }
            pBuf.putInt(0);
            pBuf.rewind();
            long k = pBuf.getLong();
            buf.position(offset + 4);
            float v = buf.getFloat();
            sparse.put(k, Float.valueOf(v));
        }
        return sparse;
    }

    private static SparseFloatArray genSparseFloatArray(List<?> objects) {
        int dim = 0;
        SparseFloatArray.Builder builder = SparseFloatArray.newBuilder();
        for (Object object : objects) {
            if (!(object instanceof SortedMap)) {
                throw new ParamException("SparseFloatVector vector field's value type must be SortedMap");
            }
            SortedMap sparse = (SortedMap)object;
            dim = Math.max(dim, sparse.size());
            ByteBuffer buf = ParamUtils.encodeSparseFloatVector(sparse);
            ByteString byteString = ByteString.copyFrom((byte[])buf.array());
            builder.addContents(byteString);
        }
        return builder.setDim(dim).build();
    }

    private static ScalarField genScalarField(FieldType fieldType, List<?> objects) {
        if (fieldType.getDataType() == DataType.Array) {
            ArrayArray.Builder builder = ArrayArray.newBuilder();
            for (Object object : objects) {
                List temp = (List)object;
                ScalarField arrayField = ParamUtils.genScalarField(fieldType.getElementType(), temp);
                builder.addData(arrayField);
            }
            return ScalarField.newBuilder().setArrayData(builder.build()).build();
        }
        return ParamUtils.genScalarField(fieldType.getDataType(), objects);
    }

    private static ScalarField genScalarField(DataType dataType, List<?> objects) {
        switch (dataType) {
            case None: 
            case UNRECOGNIZED: {
                throw new ParamException("Cannot support this dataType:" + (Object)((Object)dataType));
            }
            case Int64: {
                List longs = objects.stream().map(p -> (Long)p).collect(Collectors.toList());
                LongArray longArray = LongArray.newBuilder().addAllData(longs).build();
                return ScalarField.newBuilder().setLongData(longArray).build();
            }
            case Int32: 
            case Int16: 
            case Int8: {
                List integers = objects.stream().map(p -> p instanceof Short ? ((Short)p).intValue() : ((Integer)p).intValue()).collect(Collectors.toList());
                IntArray intArray = IntArray.newBuilder().addAllData(integers).build();
                return ScalarField.newBuilder().setIntData(intArray).build();
            }
            case Bool: {
                List booleans = objects.stream().map(p -> (Boolean)p).collect(Collectors.toList());
                BoolArray boolArray = BoolArray.newBuilder().addAllData(booleans).build();
                return ScalarField.newBuilder().setBoolData(boolArray).build();
            }
            case Float: {
                List floats = objects.stream().map(p -> (Float)p).collect(Collectors.toList());
                FloatArray floatArray = FloatArray.newBuilder().addAllData(floats).build();
                return ScalarField.newBuilder().setFloatData(floatArray).build();
            }
            case Double: {
                List doubles = objects.stream().map(p -> (Double)p).collect(Collectors.toList());
                DoubleArray doubleArray = DoubleArray.newBuilder().addAllData(doubles).build();
                return ScalarField.newBuilder().setDoubleData(doubleArray).build();
            }
            case VarChar: 
            case String: {
                List<String> strings = objects.stream().map(p -> (String)p).collect(Collectors.toList());
                StringArray stringArray = StringArray.newBuilder().addAllData(strings).build();
                return ScalarField.newBuilder().setStringData(stringArray).build();
            }
            case JSON: {
                List byteStrings = objects.stream().map(p -> ByteString.copyFromUtf8((String)p.toString())).collect(Collectors.toList());
                JSONArray jsonArray = JSONArray.newBuilder().addAllData(byteStrings).build();
                return ScalarField.newBuilder().setJsonData(jsonArray).build();
            }
        }
        throw new ParamException("Illegal scalar dataType:" + (Object)((Object)dataType));
    }

    public static FieldType ConvertField(@NonNull FieldSchema field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        FieldType.Builder builder = FieldType.newBuilder().withName(field.getName()).withDescription(field.getDescription()).withPrimaryKey(field.getIsPrimaryKey()).withPartitionKey(field.getIsPartitionKey()).withAutoID(field.getAutoID()).withDataType(field.getDataType()).withElementType(field.getElementType()).withIsDynamic(field.getIsDynamic());
        if (field.getIsDynamic()) {
            builder.withIsDynamic(true);
        }
        List<KeyValuePair> keyValuePairs = field.getTypeParamsList();
        keyValuePairs.forEach(kv -> builder.addTypeParam(kv.getKey(), kv.getValue()));
        return builder.build();
    }

    public static FieldSchema ConvertField(@NonNull FieldType field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        FieldSchema.Builder builder = FieldSchema.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setIsPrimaryKey(field.isPrimaryKey()).setIsPartitionKey(field.isPartitionKey()).setAutoID(field.isAutoID()).setDataType(field.getDataType()).setElementType(field.getElementType()).setIsDynamic(field.isDynamic());
        List<KeyValuePair> typeParamsList = ParamUtils.AssembleKvPair(field.getTypeParams());
        if (CollectionUtils.isNotEmpty(typeParamsList)) {
            typeParamsList.forEach(builder::addTypeParams);
        }
        return builder.build();
    }

    public static List<KeyValuePair> AssembleKvPair(Map<String, String> sourceMap) {
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        if (MapUtils.isNotEmpty(sourceMap)) {
            sourceMap.forEach((key, value) -> {
                KeyValuePair kv = KeyValuePair.newBuilder().setKey((String)key).setValue((String)value).build();
                result.add(kv);
            });
        }
        return result;
    }

    public static class InsertDataInfo {
        private final FieldType fieldType;
        private final LinkedList<Object> data;

        InsertDataInfo(FieldType fieldType, LinkedList<Object> data) {
            this.fieldType = fieldType;
            this.data = data;
        }

        public static InsertDataInfoBuilder builder() {
            return new InsertDataInfoBuilder();
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public LinkedList<Object> getData() {
            return this.data;
        }

        public static class InsertDataInfoBuilder {
            private FieldType fieldType;
            private LinkedList<Object> data;

            InsertDataInfoBuilder() {
            }

            public InsertDataInfoBuilder fieldType(FieldType fieldType) {
                this.fieldType = fieldType;
                return this;
            }

            public InsertDataInfoBuilder data(LinkedList<Object> data) {
                this.data = data;
                return this;
            }

            public InsertDataInfo build() {
                return new InsertDataInfo(this.fieldType, this.data);
            }

            public String toString() {
                return "ParamUtils.InsertDataInfo.InsertDataInfoBuilder(fieldType=" + this.fieldType + ", data=" + this.data + ")";
            }
        }
    }

    public static class InsertBuilderWrapper {
        private InsertRequest.Builder insertBuilder;
        private UpsertRequest.Builder upsertBuilder;

        public InsertBuilderWrapper(@NonNull InsertParam requestParam, DescCollResponseWrapper wrapper) {
            if (requestParam == null) {
                throw new NullPointerException("requestParam is marked non-null but is null");
            }
            String collectionName = requestParam.getCollectionName();
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
            this.insertBuilder = InsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getRowCount());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                this.insertBuilder.setDbName(requestParam.getDatabaseName());
            }
            this.fillFieldsData(requestParam, wrapper);
        }

        public InsertBuilderWrapper(@NonNull UpsertParam requestParam, DescCollResponseWrapper wrapper) {
            if (requestParam == null) {
                throw new NullPointerException("requestParam is marked non-null but is null");
            }
            String collectionName = requestParam.getCollectionName();
            FieldType pk = wrapper.getPrimaryField();
            if (pk.isAutoID()) {
                throw new ParamException(String.format("Upsert don't support autoID==True, collection: %s", requestParam.getCollectionName()));
            }
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
            this.upsertBuilder = UpsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getRowCount());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getDatabaseName())) {
                this.upsertBuilder.setDbName(requestParam.getDatabaseName());
            }
            this.fillFieldsData(requestParam, wrapper);
        }

        private void addFieldsData(FieldData value) {
            if (this.insertBuilder != null) {
                this.insertBuilder.addFieldsData(value);
            } else if (this.upsertBuilder != null) {
                this.upsertBuilder.addFieldsData(value);
            }
        }

        private void setPartitionName(String value) {
            if (this.insertBuilder != null) {
                this.insertBuilder.setPartitionName(value);
            } else if (this.upsertBuilder != null) {
                this.upsertBuilder.setPartitionName(value);
            }
        }

        private void fillFieldsData(InsertParam requestParam, DescCollResponseWrapper wrapper) {
            String partitionName = requestParam.getPartitionName();
            boolean isPartitionKeyEnabled = false;
            for (FieldType fieldType : wrapper.getFields()) {
                if (!fieldType.isPartitionKey()) continue;
                isPartitionKeyEnabled = true;
                break;
            }
            if (isPartitionKeyEnabled) {
                if (partitionName != null && !partitionName.isEmpty()) {
                    String msg = String.format("Collection %s has partition key, not allow to specify partition name", requestParam.getCollectionName());
                    throw new ParamException(msg);
                }
            } else if (partitionName != null) {
                this.setPartitionName(partitionName);
            }
            List<InsertParam.Field> columnFields = requestParam.getFields();
            List<JsonObject> rowFields = requestParam.getRows();
            if (CollectionUtils.isNotEmpty(columnFields)) {
                this.checkAndSetColumnData(wrapper, columnFields);
            } else {
                this.checkAndSetRowData(wrapper, rowFields);
            }
        }

        private void checkAndSetColumnData(DescCollResponseWrapper wrapper, List<InsertParam.Field> fields) {
            List<FieldType> fieldTypes = wrapper.getFields();
            for (FieldType fieldType : fieldTypes) {
                boolean found = false;
                for (InsertParam.Field field : fields) {
                    if (!field.getName().equals(fieldType.getName())) continue;
                    if (fieldType.isAutoID()) {
                        String msg = String.format("The primary key: %s is auto generated, no need to input.", fieldType.getName());
                        throw new ParamException(msg);
                    }
                    ParamUtils.checkFieldData(fieldType, field);
                    found = true;
                    this.addFieldsData(ParamUtils.genFieldData(fieldType, field.getValues()));
                    break;
                }
                if (found || fieldType.isAutoID()) continue;
                throw new ParamException(String.format("The field: %s is not provided.", fieldType.getName()));
            }
            if (wrapper.getEnableDynamicField()) {
                for (InsertParam.Field field : fields) {
                    if (!field.getName().equals("$meta")) continue;
                    FieldType dynamicType = FieldType.newBuilder().withName("$meta").withDataType(DataType.JSON).withIsDynamic(true).build();
                    ParamUtils.checkFieldData(dynamicType, field);
                    this.addFieldsData(ParamUtils.genFieldData(dynamicType, field.getValues(), true));
                    break;
                }
            }
        }

        private void checkAndSetRowData(DescCollResponseWrapper wrapper, List<JsonObject> rows) {
            List<FieldType> fieldTypes = wrapper.getFields();
            HashMap<String, InsertDataInfo> nameInsertInfo = new HashMap<String, InsertDataInfo>();
            InsertDataInfo insertDynamicDataInfo = InsertDataInfo.builder().fieldType(FieldType.newBuilder().withName("$meta").withDataType(DataType.JSON).withIsDynamic(true).build()).data(new LinkedList<Object>()).build();
            for (JsonObject row : rows) {
                for (FieldType fieldType : fieldTypes) {
                    String msg;
                    String fieldName = fieldType.getName();
                    InsertDataInfo insertDataInfo = nameInsertInfo.getOrDefault(fieldName, InsertDataInfo.builder().fieldType(fieldType).data(new LinkedList<Object>()).build());
                    JsonElement rowFieldData = row.get(fieldName);
                    if (rowFieldData != null && !rowFieldData.isJsonNull()) {
                        if (fieldType.isAutoID()) {
                            msg = String.format("The primary key: %s is auto generated, no need to input.", fieldName);
                            throw new ParamException(msg);
                        }
                        Object fieldValue = ParamUtils.checkFieldValue(fieldType, rowFieldData);
                        insertDataInfo.getData().add(fieldValue);
                        nameInsertInfo.put(fieldName, insertDataInfo);
                        continue;
                    }
                    if (fieldType.isAutoID()) continue;
                    msg = String.format("The field: %s is not provided.", fieldType.getName());
                    throw new ParamException(msg);
                }
                if (!wrapper.getEnableDynamicField()) continue;
                JsonObject dynamicField = new JsonObject();
                for (String rowFieldName : row.keySet()) {
                    if (nameInsertInfo.containsKey(rowFieldName)) continue;
                    dynamicField.add(rowFieldName, row.get(rowFieldName));
                }
                insertDynamicDataInfo.getData().add(dynamicField);
            }
            for (String fieldNameKey : nameInsertInfo.keySet()) {
                InsertDataInfo insertDataInfo = (InsertDataInfo)nameInsertInfo.get(fieldNameKey);
                this.addFieldsData(ParamUtils.genFieldData(insertDataInfo.getFieldType(), insertDataInfo.getData()));
            }
            if (wrapper.getEnableDynamicField()) {
                this.addFieldsData(ParamUtils.genFieldData(insertDynamicDataInfo.getFieldType(), insertDynamicDataInfo.getData(), Boolean.TRUE));
            }
        }

        public InsertRequest buildInsertRequest() {
            if (this.insertBuilder != null) {
                return this.insertBuilder.build();
            }
            throw new ParamException("Unable to build insert request since no input");
        }

        public UpsertRequest buildUpsertRequest() {
            if (this.upsertBuilder != null) {
                return this.upsertBuilder.build();
            }
            throw new ParamException("Unable to build upsert request since no input");
        }
    }
}

