/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DslType;
import io.milvus.grpc.HybridSearchRequest;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.PlaceholderType;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.SearchRequest;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.service.vector.request.AnnSearchReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.request.ranker.BaseRanker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class VectorUtils {
    private static final Gson GSON_INSTANCE = new Gson();

    public QueryRequest ConvertToGrpcQueryRequest(QueryReq request) {
        long limit;
        QueryRequest.Builder builder = QueryRequest.newBuilder().setCollectionName(request.getCollectionName()).addAllPartitionNames(request.getPartitionNames()).addAllOutputFields(request.getOutputFields()).setExpr(request.getFilter());
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        long offset = request.getOffset();
        if (offset > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(offset)).build());
        }
        if ((limit = request.getLimit()) > 0L) {
            builder.addQueryParams(KeyValuePair.newBuilder().setKey("limit").setValue(String.valueOf(limit)).build());
        }
        return builder.build();
    }

    private static long getGuaranteeTimestamp(ConsistencyLevel consistencyLevel, long guaranteeTimestamp, Long gracefulTime) {
        if (consistencyLevel == null) {
            return 1L;
        }
        switch (consistencyLevel) {
            case STRONG: {
                guaranteeTimestamp = 0L;
                break;
            }
            case BOUNDED: {
                guaranteeTimestamp = new Date().getTime() - gracefulTime;
                break;
            }
            case EVENTUALLY: {
                guaranteeTimestamp = 1L;
            }
        }
        return guaranteeTimestamp;
    }

    public SearchRequest ConvertToGrpcSearchRequest(SearchReq request) {
        List<BaseVector> vectors;
        SearchRequest.Builder builder = SearchRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (!request.getPartitionNames().isEmpty()) {
            request.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if ((vectors = request.getData()).isEmpty()) {
            throw new ParamException("Target vectors list of search request is empty.");
        }
        PlaceholderType plType = vectors.get(0).getPlaceholderType();
        ArrayList<Object> data = new ArrayList<Object>();
        for (BaseVector vector : vectors) {
            if (vector.getPlaceholderType() != plType) {
                throw new ParamException("Different types of target vectors in a search request is not allowed.");
            }
            data.add(vector.getData());
        }
        ByteString byteStr = ParamUtils.convertPlaceholder(data, plType);
        builder.setPlaceholderGroup(byteStr);
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(request.getAnnsField()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(request.getTopK())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("round_decimal").setValue(String.valueOf(request.getRoundDecimal())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("ignore_growing").setValue(String.valueOf(request.isIgnoreGrowing())).build()).addSearchParams(KeyValuePair.newBuilder().setKey("offset").setValue(String.valueOf(request.getOffset())).build());
        if (null != request.getSearchParams()) {
            try {
                String searchParams = GSON_INSTANCE.toJson(request.getSearchParams());
                builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(searchParams).build());
            }
            catch (IllegalArgumentException e) {
                throw new ParamException(e.getMessage() + e.getCause().getMessage());
            }
        }
        if (request.getGroupByFieldName() != null && !request.getGroupByFieldName().isEmpty()) {
            builder.addSearchParams(KeyValuePair.newBuilder().setKey("group_by_field").setValue(request.getGroupByFieldName()).build());
        }
        if (!request.getOutputFields().isEmpty()) {
            request.getOutputFields().forEach(builder::addOutputFields);
        }
        builder.setDslType(DslType.BoolExprV1);
        if (request.getFilter() != null && !request.getFilter().isEmpty()) {
            builder.setDsl(request.getFilter());
        }
        long guaranteeTimestamp = VectorUtils.getGuaranteeTimestamp(request.getConsistencyLevel(), request.getGuaranteeTimestamp(), request.getGracefulTime());
        builder.setGuaranteeTimestamp(guaranteeTimestamp);
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public static SearchRequest convertAnnSearchParam(@NonNull AnnSearchReq annSearchReq, ConsistencyLevel consistencyLevel) {
        if (annSearchReq == null) {
            throw new NullPointerException("annSearchReq is marked non-null but is null");
        }
        SearchRequest.Builder builder = SearchRequest.newBuilder();
        List<BaseVector> vectors = annSearchReq.getVectors();
        if (vectors.isEmpty()) {
            throw new ParamException("Target vectors list of search request is empty.");
        }
        PlaceholderType plType = vectors.get(0).getPlaceholderType();
        ArrayList<Object> data = new ArrayList<Object>();
        for (BaseVector vector : vectors) {
            if (vector.getPlaceholderType() != plType) {
                throw new ParamException("Different types of target vectors in a search request is not allowed.");
            }
            data.add(vector.getData());
        }
        ByteString byteStr = ParamUtils.convertPlaceholder(data, plType);
        builder.setPlaceholderGroup(byteStr);
        builder.setNq(vectors.size());
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("anns_field").setValue(annSearchReq.getVectorFieldName()).build()).addSearchParams(KeyValuePair.newBuilder().setKey("topk").setValue(String.valueOf(annSearchReq.getTopK())).build());
        String params = "{}";
        if (null != annSearchReq.getParams() && !annSearchReq.getParams().isEmpty()) {
            params = annSearchReq.getParams();
        }
        builder.addSearchParams(KeyValuePair.newBuilder().setKey("params").setValue(params).build());
        builder.setDslType(DslType.BoolExprV1);
        if (annSearchReq.getExpr() != null && !annSearchReq.getExpr().isEmpty()) {
            builder.setDsl(annSearchReq.getExpr());
        }
        if (consistencyLevel == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(consistencyLevel.getCode());
        }
        return builder.build();
    }

    public HybridSearchRequest ConvertToGrpcHybridSearchRequest(HybridSearchReq request) {
        HybridSearchRequest.Builder builder = HybridSearchRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (request.getPartitionNames() != null && !request.getPartitionNames().isEmpty()) {
            request.getPartitionNames().forEach(builder::addPartitionNames);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        if (request.getSearchRequests() == null || request.getSearchRequests().isEmpty()) {
            throw new ParamException("Sub-request list is empty.");
        }
        for (AnnSearchReq req : request.getSearchRequests()) {
            SearchRequest searchRequest = VectorUtils.convertAnnSearchParam(req, request.getConsistencyLevel());
            builder.addRequests(searchRequest);
        }
        BaseRanker ranker = request.getRanker();
        if (request.getRanker() == null) {
            throw new ParamException("Ranker is null.");
        }
        Map<String, String> props = ranker.getProperties();
        props.put("limit", String.format("%d", request.getTopK()));
        props.put("round_decimal", String.format("%d", request.getRoundDecimal()));
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(props);
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addRankParams);
        }
        if (request.getOutFields() != null && !request.getOutFields().isEmpty()) {
            request.getOutFields().forEach(builder::addOutputFields);
        }
        if (request.getConsistencyLevel() == null) {
            builder.setUseDefaultConsistency(true);
        } else {
            builder.setConsistencyLevelValue(request.getConsistencyLevel().getCode());
        }
        return builder.build();
    }

    public String getExprById(String primaryFieldName, List<?> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append(primaryFieldName).append(" in [");
        for (Object id : ids) {
            if (id instanceof String) {
                sb.append("\"").append(id.toString()).append("\",");
                continue;
            }
            sb.append(id.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

