/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateCollectionParam {
    private final String collectionName;
    private final int shardsNum;
    private final String description;
    private final int partitionsNum;
    private final ConsistencyLevelEnum consistencyLevel;
    private final String databaseName;
    private final List<FieldType> fieldTypes;
    private final boolean enableDynamicField;
    private final Map<String, String> properties = new HashMap<String, String>();

    private CreateCollectionParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.shardsNum = builder.shardsNum;
        this.description = builder.description;
        this.fieldTypes = builder.fieldTypes;
        this.partitionsNum = builder.partitionsNum;
        this.consistencyLevel = builder.consistencyLevel;
        this.databaseName = builder.databaseName;
        this.enableDynamicField = builder.enableDynamicField;
        this.properties.putAll(builder.properties);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getShardsNum() {
        return this.shardsNum;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPartitionsNum() {
        return this.partitionsNum;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public List<FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public boolean isEnableDynamicField() {
        return this.enableDynamicField;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "CreateCollectionParam{collectionName='" + this.collectionName + '\'' + ", shardsNum=" + this.shardsNum + ", description='" + this.description + '\'' + ", partitionsNum=" + this.partitionsNum + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", databaseName='" + this.databaseName + '\'' + ", fieldTypes=" + this.fieldTypes + ", enableDynamicField=" + this.enableDynamicField + ", properties=" + this.properties + '}';
    }

    public static final class Builder {
        private String collectionName;
        private int shardsNum = 0;
        private String description = "";
        private List<FieldType> fieldTypes = new ArrayList<FieldType>();
        private int partitionsNum = 0;
        private ConsistencyLevelEnum consistencyLevel = ConsistencyLevelEnum.BOUNDED;
        private String databaseName;
        private CollectionSchemaParam schema;
        private boolean enableDynamicField;
        private final Map<String, String> properties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("Collection name cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withShardsNum(int shardsNum) {
            this.shardsNum = shardsNum;
            return this;
        }

        @Deprecated
        public Builder withEnableDynamicField(boolean enableDynamicField) {
            this.enableDynamicField = enableDynamicField;
            return this;
        }

        public Builder withDescription(String description) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null");
            }
            this.description = description;
            return this;
        }

        @Deprecated
        public Builder withFieldTypes(List<FieldType> fieldTypes) {
            if (fieldTypes == null) {
                throw new IllegalArgumentException("FieldTypes cannot be null");
            }
            this.fieldTypes.addAll(fieldTypes);
            return this;
        }

        @Deprecated
        public Builder addFieldType(FieldType fieldType) {
            if (fieldType == null) {
                throw new IllegalArgumentException("FieldType cannot be null");
            }
            this.fieldTypes.add(fieldType);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            if (consistencyLevel == null) {
                throw new IllegalArgumentException("ConsistencyLevel cannot be null");
            }
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder withPartitionsNum(int partitionsNum) {
            this.partitionsNum = partitionsNum;
            return this;
        }

        public Builder withSchema(CollectionSchemaParam schema) {
            if (schema == null) {
                throw new IllegalArgumentException("Schema cannot be null");
            }
            this.schema = schema;
            return this;
        }

        public Builder withReplicaNumber(int replicaNumber) {
            return this.withProperty("collection.replica.number", Integer.toString(replicaNumber));
        }

        public Builder withResourceGroups(List<String> resourceGroups) {
            if (resourceGroups == null) {
                throw new IllegalArgumentException("ResourceGroups cannot be null");
            }
            return this.withProperty("collection.resource_groups", String.join((CharSequence)",", resourceGroups));
        }

        public Builder withProperty(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            this.properties.put(key, value);
            return this;
        }

        public CreateCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.shardsNum < 0) {
                throw new ParamException("ShardNum must be larger or equal to 0");
            }
            if (!this.fieldTypes.isEmpty() && this.schema != null) {
                throw new ParamException("Please use either withFieldTypes(), addFieldType(), or withSchema(), and do not use them simultaneously.");
            }
            if (this.schema != null) {
                this.fieldTypes = this.schema.getFieldTypes();
                this.enableDynamicField = this.schema.isEnableDynamicField();
            }
            if (this.fieldTypes.isEmpty()) {
                throw new ParamException("Field numbers must be larger than 0");
            }
            boolean hasPartitionKey = false;
            for (FieldType fieldType : this.fieldTypes) {
                if (fieldType == null) {
                    throw new ParamException("Collection field cannot be null");
                }
                if (!fieldType.isPartitionKey()) continue;
                if (hasPartitionKey) {
                    throw new ParamException("Only one partition key field is allowed in a collection");
                }
                hasPartitionKey = true;
            }
            if (this.partitionsNum > 0 && !hasPartitionKey) {
                throw new ParamException("None of fields is partition key, not allow to define partition number");
            }
            return new CreateCollectionParam(this);
        }
    }
}

