/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DropDatabaseParam {
    private final String databaseName;

    private DropDatabaseParam(Builder builder) {
        if (builder.databaseName == null) {
            throw new IllegalArgumentException("databaseName cannot be null");
        }
        this.databaseName = builder.databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "DropDatabaseParam{databaseName='" + this.databaseName + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String databaseName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            if (databaseName == null) {
                throw new IllegalArgumentException("databaseName cannot be null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public DropDatabaseParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.databaseName, "Database name");
            return new DropDatabaseParam(this);
        }
    }
}

