/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FlushParam {
    private final String databaseName;
    private final List<String> collectionNames;
    private final Boolean syncFlush;
    private final long syncFlushWaitingInterval;
    private final long syncFlushWaitingTimeout;

    private FlushParam(Builder builder) {
        if (builder.collectionNames == null) {
            throw new IllegalArgumentException("collectionNames cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionNames = builder.collectionNames;
        this.syncFlush = builder.syncFlush;
        this.syncFlushWaitingInterval = builder.syncFlushWaitingInterval;
        this.syncFlushWaitingTimeout = builder.syncFlushWaitingTimeout;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public List<String> getCollectionNames() {
        return this.collectionNames;
    }

    public Boolean getSyncFlush() {
        return this.syncFlush;
    }

    public long getSyncFlushWaitingInterval() {
        return this.syncFlushWaitingInterval;
    }

    public long getSyncFlushWaitingTimeout() {
        return this.syncFlushWaitingTimeout;
    }

    public String toString() {
        return "FlushParam{databaseName='" + this.databaseName + '\'' + ", collectionNames=" + this.collectionNames + ", syncFlush=" + this.syncFlush + ", syncFlushWaitingInterval=" + this.syncFlushWaitingInterval + ", syncFlushWaitingTimeout=" + this.syncFlushWaitingTimeout + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String databaseName;
        private final List<String> collectionNames = new ArrayList<String>();
        private Boolean syncFlush = Boolean.TRUE;
        private Long syncFlushWaitingInterval = 500L;
        private Long syncFlushWaitingTimeout = 60L;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionNames(List<String> collectionNames) {
            if (collectionNames == null) {
                throw new IllegalArgumentException("collectionNames cannot be null");
            }
            this.collectionNames.addAll(collectionNames);
            return this;
        }

        public Builder addCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionNames.add(collectionName);
            return this;
        }

        public Builder withSyncFlush(Boolean syncFlush) {
            if (syncFlush == null) {
                throw new IllegalArgumentException("syncFlush cannot be null");
            }
            this.syncFlush = syncFlush;
            return this;
        }

        public Builder withSyncFlushWaitingInterval(Long milliseconds) {
            if (milliseconds == null) {
                throw new IllegalArgumentException("milliseconds cannot be null");
            }
            this.syncFlushWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncFlushWaitingTimeout(Long seconds) {
            if (seconds == null) {
                throw new IllegalArgumentException("seconds cannot be null");
            }
            this.syncFlushWaitingTimeout = seconds;
            return this;
        }

        public FlushParam build() throws ParamException {
            if (this.collectionNames.isEmpty()) {
                throw new ParamException("CollectionNames can not be empty");
            }
            for (String name : this.collectionNames) {
                ParamUtils.CheckNullEmptyString(name, "Collection name");
            }
            if (Objects.equals(this.syncFlush, Boolean.TRUE)) {
                if (this.syncFlushWaitingInterval <= 0L) {
                    throw new ParamException("Sync flush waiting interval must be larger than zero");
                }
                if (this.syncFlushWaitingInterval > Constant.MAX_WAITING_FLUSHING_INTERVAL) {
                    throw new ParamException("Sync flush waiting interval cannot be larger than " + Constant.MAX_WAITING_FLUSHING_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncFlushWaitingTimeout <= 0L) {
                    throw new ParamException("Sync flush waiting timeout must be larger than zero");
                }
                if (this.syncFlushWaitingTimeout > Constant.MAX_WAITING_FLUSHING_TIMEOUT) {
                    throw new ParamException("Sync flush waiting timeout cannot be larger than " + Constant.MAX_WAITING_FLUSHING_TIMEOUT.toString() + " seconds");
                }
            }
            return new FlushParam(this);
        }
    }
}

