/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class GetCollectionStatisticsParam {
    private final String databaseName;
    private final String collectionName;
    private final boolean flushCollection;

    private GetCollectionStatisticsParam(Builder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.flushCollection = builder.flushCollection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isFlushCollection() {
        return this.flushCollection;
    }

    public String toString() {
        return "GetCollectionStatisticsParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", flushCollection=" + this.flushCollection + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private Boolean flushCollection = Boolean.FALSE;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFlush(Boolean flush) {
            if (flush == null) {
                throw new IllegalArgumentException("flush cannot be null");
            }
            this.flushCollection = flush;
            return this;
        }

        public GetCollectionStatisticsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetCollectionStatisticsParam(this);
        }
    }
}

