/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LoadCollectionParam {
    private final String databaseName;
    private final String collectionName;
    private final boolean syncLoad;
    private final long syncLoadWaitingInterval;
    private final long syncLoadWaitingTimeout;
    private final int replicaNumber;
    private final boolean refresh;
    private final List<String> resourceGroups;
    private final List<String> loadFields;
    private final boolean skipLoadDynamicField;

    public LoadCollectionParam(Builder builder) {
        if (builder.collectionName == null) {
            throw new IllegalArgumentException("collectionName cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.syncLoad = builder.syncLoad;
        this.syncLoadWaitingInterval = builder.syncLoadWaitingInterval;
        this.syncLoadWaitingTimeout = builder.syncLoadWaitingTimeout;
        this.replicaNumber = builder.replicaNumber;
        this.refresh = builder.refresh;
        this.resourceGroups = builder.resourceGroups;
        this.loadFields = builder.loadFields;
        this.skipLoadDynamicField = builder.skipLoadDynamicField;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isSyncLoad() {
        return this.syncLoad;
    }

    public long getSyncLoadWaitingInterval() {
        return this.syncLoadWaitingInterval;
    }

    public long getSyncLoadWaitingTimeout() {
        return this.syncLoadWaitingTimeout;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public List<String> getResourceGroups() {
        return this.resourceGroups;
    }

    public List<String> getLoadFields() {
        return this.loadFields;
    }

    public boolean isSkipLoadDynamicField() {
        return this.skipLoadDynamicField;
    }

    public String toString() {
        return "LoadCollectionParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", syncLoad=" + this.syncLoad + ", syncLoadWaitingInterval=" + this.syncLoadWaitingInterval + ", syncLoadWaitingTimeout=" + this.syncLoadWaitingTimeout + ", replicaNumber=" + this.replicaNumber + ", refresh=" + this.refresh + ", resourceGroups=" + this.resourceGroups + ", loadFields=" + this.loadFields + ", skipLoadDynamicField=" + this.skipLoadDynamicField + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private Boolean syncLoad = Boolean.TRUE;
        private Long syncLoadWaitingInterval = 500L;
        private Long syncLoadWaitingTimeout = 60L;
        private Integer replicaNumber = 0;
        private Boolean refresh = Boolean.FALSE;
        private List<String> resourceGroups = new ArrayList<String>();
        private List<String> loadFields = new ArrayList<String>();
        private Boolean skipLoadDynamicField = Boolean.FALSE;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withSyncLoad(Boolean syncLoad) {
            if (syncLoad == null) {
                throw new IllegalArgumentException("syncLoad cannot be null");
            }
            this.syncLoad = syncLoad;
            return this;
        }

        public Builder withSyncLoadWaitingInterval(Long milliseconds) {
            if (milliseconds == null) {
                throw new IllegalArgumentException("milliseconds cannot be null");
            }
            this.syncLoadWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncLoadWaitingTimeout(Long seconds) {
            if (seconds == null) {
                throw new IllegalArgumentException("seconds cannot be null");
            }
            this.syncLoadWaitingTimeout = seconds;
            return this;
        }

        public Builder withReplicaNumber(Integer replicaNumber) {
            if (replicaNumber == null) {
                throw new IllegalArgumentException("replicaNumber cannot be null");
            }
            this.replicaNumber = replicaNumber;
            return this;
        }

        public Builder withRefresh(Boolean refresh) {
            if (refresh == null) {
                throw new IllegalArgumentException("refresh cannot be null");
            }
            this.refresh = refresh;
            return this;
        }

        public Builder withResourceGroups(List<String> resourceGroups) {
            if (resourceGroups == null) {
                throw new IllegalArgumentException("resourceGroups cannot be null");
            }
            this.resourceGroups.addAll(resourceGroups);
            return this;
        }

        public Builder withLoadFields(List<String> loadFields) {
            if (loadFields == null) {
                throw new IllegalArgumentException("loadFields cannot be null");
            }
            loadFields.forEach(field -> {
                if (!this.loadFields.contains(field)) {
                    this.loadFields.add((String)field);
                }
            });
            return this;
        }

        public Builder withSkipLoadDynamicField(Boolean skip) {
            if (skip == null) {
                throw new IllegalArgumentException("skip cannot be null");
            }
            this.skipLoadDynamicField = skip;
            return this;
        }

        public LoadCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (Objects.equals(this.syncLoad, Boolean.TRUE)) {
                if (this.syncLoadWaitingInterval <= 0L) {
                    throw new ParamException("Sync load waiting interval must be larger than zero");
                }
                if (this.syncLoadWaitingInterval > Constant.MAX_WAITING_LOADING_INTERVAL) {
                    throw new ParamException("Sync load waiting interval cannot be larger than " + Constant.MAX_WAITING_LOADING_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncLoadWaitingTimeout <= 0L) {
                    throw new ParamException("Sync load waiting timeout must be larger than zero");
                }
                if (this.syncLoadWaitingTimeout > Constant.MAX_WAITING_LOADING_TIMEOUT) {
                    throw new ParamException("Sync load waiting timeout cannot be larger than " + Constant.MAX_WAITING_LOADING_TIMEOUT.toString() + " seconds");
                }
            }
            if (this.replicaNumber < 0) {
                throw new ParamException("Replica number can't be negative");
            }
            return new LoadCollectionParam(this);
        }
    }
}

